/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

import com.ibm.icu.dev.tool.localeconverter.ConvertJavaLocale;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;

public class ConvertAllJavaLocales {
    public static void main(String[] args) {
        try {
            new ConvertAllJavaLocales(args);
        }
        catch (Throwable t) {
            System.err.println("Unknown error: " + t);
        }
    }

    public ConvertAllJavaLocales(String[] argsIn) {
        try {
            String packageName = argsIn[0];
            System.out.println("This is the packagename : " + packageName);
            String classname = packageName + ".Locale";
            System.out.println("This is the classname : " + classname);
            Locale[] locales = Locale.getAvailableLocales();
            int i = 0;
            while (i < locales.length) {
                String localeName = locales[i].toString();
                String[] args = new String[]{"-package", packageName, "-icu", localeName};
                System.out.println("Converting " + localeName);
                FileOutputStream outFile = new FileOutputStream("ICULocale_" + localeName);
                PrintStream out = new PrintStream(outFile, true);
                new ConvertJavaLocale(args, out);
                out.close();
                ++i;
            }
        }
        catch (IOException e) {
            System.err.println("Unexpected IO error");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

