/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.localeconverter;

public class CollationItem {
    private static final char[] OP_CHARS = new char[]{'=', '<', ';', ',', '&'};
    private static final char[] SPECIAL_CHARS = new char[]{'&', '@', '=', '<', ';', ','};
    public static final int NONE = 0;
    public static final int PRIMARY = 1;
    public static final int SECONDARY = 2;
    public static final int TERTIARY = 3;
    private static final int FIRST = 4;
    public int op;
    public String item;
    public String expansion;
    public String comment;
    public static final CollationItem FORWARD = new CollationItem(0, ""){

        public String toString() {
            return "";
        }
    };
    public static final CollationItem BACKWARD = new CollationItem(0, ""){

        public String toString() {
            return "@";
        }
    };

    public CollationItem(String item) {
        this.op = 4;
        this.item = this.cleanString(item);
        this.expansion = "";
    }

    public CollationItem(int op, String item) {
        this(op, item, null);
    }

    public CollationItem(int op, String item, String expansion) {
        this.op = Math.abs(op);
        if (this.op > 3) {
            this.op = 3;
        }
        this.item = this.cleanString(item);
        this.expansion = this.cleanString(expansion);
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String toString() {
        String itemString = this.item;
        if (this.expansion.length() == 0) {
            return "" + OP_CHARS[this.op] + this.item;
        }
        return "&" + this.expansion + OP_CHARS[this.op] + this.item;
    }

    private String cleanString(String source) {
        if (source == null) {
            return "";
        }
        String result = source;
        int i = 0;
        while (i < result.length()) {
            char c = result.charAt(i);
            if (c == '@' || c == '\t' || c == '\n' || c == '\f' || c == '\r' || c == '\u000b' || c <= '/' && c >= ' ' || c <= '?' && c >= ':' || c <= '`' && c >= '[' || c <= '~' && c >= '{') {
                result = i < result.length() - 1 ? result.substring(0, i) + "'" + c + "'" + result.substring(i + 1) : result.substring(0, i) + "'" + c + "'";
                i += 2;
            }
            ++i;
        }
        return result;
    }
}

