/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.dev.tool.compression;

class CompressionTableGenerator {
    static final int LATININDEX = 249;
    static final int IPAEXTENSIONINDEX = 250;
    static final int GREEKINDEX = 251;
    static final int ARMENIANINDEX = 252;
    static final int HIRAGANAINDEX = 253;
    static final int KATAKANAINDEX = 254;
    static final int HALFWIDTHKATAKANAINDEX = 255;
    static final int SDEFINEX = 11;
    static final int SRESERVED = 12;
    static final int SQUOTEU = 14;
    static final int SCHANGEU = 15;
    static final int SQUOTE0 = 1;
    static final int SQUOTE1 = 2;
    static final int SQUOTE2 = 3;
    static final int SQUOTE3 = 4;
    static final int SQUOTE4 = 5;
    static final int SQUOTE5 = 6;
    static final int SQUOTE6 = 7;
    static final int SQUOTE7 = 8;
    static final int SCHANGE0 = 16;
    static final int SCHANGE1 = 17;
    static final int SCHANGE2 = 18;
    static final int SCHANGE3 = 19;
    static final int SCHANGE4 = 20;
    static final int SCHANGE5 = 21;
    static final int SCHANGE6 = 22;
    static final int SCHANGE7 = 23;
    static final int SDEFINE0 = 24;
    static final int SDEFINE1 = 25;
    static final int SDEFINE2 = 26;
    static final int SDEFINE3 = 27;
    static final int SDEFINE4 = 28;
    static final int SDEFINE5 = 29;
    static final int SDEFINE6 = 30;
    static final int SDEFINE7 = 31;
    static final int UCHANGE0 = 224;
    static final int UCHANGE1 = 225;
    static final int UCHANGE2 = 226;
    static final int UCHANGE3 = 227;
    static final int UCHANGE4 = 228;
    static final int UCHANGE5 = 229;
    static final int UCHANGE6 = 230;
    static final int UCHANGE7 = 231;
    static final int UDEFINE0 = 232;
    static final int UDEFINE1 = 233;
    static final int UDEFINE2 = 234;
    static final int UDEFINE3 = 235;
    static final int UDEFINE4 = 236;
    static final int UDEFINE5 = 237;
    static final int UDEFINE6 = 238;
    static final int UDEFINE7 = 239;
    static final int UQUOTEU = 240;
    static final int UDEFINEX = 241;
    static final int URESERVED = 242;
    static final int BLOCKSIZE = 255;

    CompressionTableGenerator() {
    }

    static void printOffsetTable() {
        int i = 0;
        int[] offsetTable = new int[256];
        i = 1;
        while (i < 104) {
            offsetTable[i] = i * 128;
            ++i;
        }
        i = 104;
        while (i < 168) {
            offsetTable[i] = i * 128 + 44032;
            ++i;
        }
        offsetTable[249] = 192;
        offsetTable[250] = 592;
        offsetTable[251] = 880;
        offsetTable[252] = 1328;
        offsetTable[253] = 12352;
        offsetTable[254] = 12448;
        offsetTable[255] = 65376;
        System.out.println("static int [] sOffsetTable = {");
        i = 0;
        while (i < offsetTable.length - 1) {
            System.out.print("0x" + Integer.toHexString(offsetTable[i]) + ", ");
            ++i;
        }
        i = offsetTable.length - 1;
        while (i < offsetTable.length) {
            System.out.print("0x" + Integer.toHexString(offsetTable[i]));
            ++i;
        }
        System.out.println();
        System.out.println("};");
    }

    static void printSingleTagTable() {
        int i = 0;
        boolean[] singleTagTable = new boolean[256];
        i = 0;
        while (i <= 255) {
            switch (i) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: {
                    singleTagTable[i] = true;
                    break;
                }
                default: {
                    singleTagTable[i] = false;
                }
            }
            ++i;
        }
        System.out.println("private static boolean [] sSingleTagTable = {");
        i = 0;
        while (i < singleTagTable.length - 1) {
            System.out.print(singleTagTable[i] + ", ");
            ++i;
        }
        i = singleTagTable.length - 1;
        while (i < singleTagTable.length) {
            System.out.print(singleTagTable[i]);
            ++i;
        }
        System.out.println();
        System.out.println("};");
    }

    static void printUnicodeTagTable() {
        int i = 0;
        boolean[] unicodeTagTable = new boolean[256];
        i = 0;
        while (i <= 255) {
            switch (i) {
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: 
                case 240: 
                case 241: 
                case 242: {
                    unicodeTagTable[i] = true;
                    break;
                }
                default: {
                    unicodeTagTable[i] = false;
                }
            }
            ++i;
        }
        System.out.println("private static boolean [] sUnicodeTagTable = {");
        i = 0;
        while (i < unicodeTagTable.length - 1) {
            System.out.print(unicodeTagTable[i] + ", ");
            ++i;
        }
        i = unicodeTagTable.length - 1;
        while (i < unicodeTagTable.length) {
            System.out.print(unicodeTagTable[i]);
            ++i;
        }
        System.out.println();
        System.out.println("};");
    }

    public static void main(String[] argv) {
        CompressionTableGenerator.printOffsetTable();
        CompressionTableGenerator.printSingleTagTable();
        CompressionTableGenerator.printUnicodeTagTable();
    }
}

