/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.APILogger;
import com.sap.tc.logging.Formatter;
import com.sap.tc.logging.ListFormatter;
import com.sap.tc.logging.Log;
import com.sap.tc.logging.MSGCollection;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

public class StreamLog
extends Log {
    private static String subLoc = "Log";
    private OutputStream stream;
    private OutputStreamWriter out;
    private String enc;

    protected StreamLog() {
        this((String)null, (Formatter)new ListFormatter());
    }

    protected StreamLog(Formatter formatter) {
        this((String)null, formatter);
    }

    protected StreamLog(String enc, Formatter formatter) {
        super(formatter);
        this.enc = enc;
        this.stream = null;
        this.out = null;
    }

    public StreamLog(OutputStream stream) {
        this(stream, (Formatter)new ListFormatter());
    }

    public StreamLog(OutputStream stream, Formatter formatter) {
        super(formatter);
        this.stream = stream;
        this.enc = null;
        try {
            this.openInt();
        }
        catch (IOException ex) {
            APILogger.logIntByAPI(500, subLoc + "[StreamLog(...)]", MSGCollection.LOGGING_MSG_ID_OPEN_EXCEPTION, MSGCollection.LOGGING_MSG_STR_OPEN_EXCEPTION, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
            this.handleException(ex);
        }
    }

    public StreamLog(OutputStream stream, String enc) throws UnsupportedEncodingException {
        this(stream, enc, new ListFormatter());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public StreamLog(OutputStream stream, String enc, Formatter formatter) throws UnsupportedEncodingException {
        super(formatter);
        this.stream = stream;
        this.enc = enc;
        try {
            try {
                this.openInt();
            }
            catch (IOException ex) {
                APILogger.logIntByAPI(200, subLoc + "[StreamLog(...)]", MSGCollection.LOGGING_MSG_ID_OPEN_EXCEPTION, MSGCollection.LOGGING_MSG_STR_OPEN_EXCEPTION, new String[]{this.getName()});
                APILogger.catchingIntByAPI(ex);
                Object var6_5 = null;
                if (this.out != null) return;
                if (enc != null) return;
                throw new UnsupportedEncodingException();
            }
            Object var6_4 = null;
            if (this.out != null) return;
            if (enc != null) return;
            throw new UnsupportedEncodingException();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (this.out != null || enc != null) throw throwable;
            throw new UnsupportedEncodingException();
        }
    }

    public synchronized String getEncoding() {
        return this.enc;
    }

    public void setEncoding(String enc) {
        String oldValue = "";
        String newValue = "";
        try {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                oldValue = this.getEncoding();
                this.enc = enc;
                this.closeInt();
                newValue = this.getEncoding();
            }
            APILogger.instrumentIntByAPI(subLoc + "[setEncoding(String enc)]", MSGCollection.CONFIGURATION_IS_CHANGED_ID, MSGCollection.CONFIGURATION_IS_CHANGED_TEXT, new Object[]{"encoding", "Log", this.getName(), oldValue, newValue});
        }
        catch (IOException ex) {
            APILogger.logIntByAPI(500, subLoc + "[setEncoding(...)]", MSGCollection.LOGGING_MSG_ID_CLOSE_EXCEPTION, MSGCollection.LOGGING_MSG_STR_CLOSE_EXCEPTION, new String[]{this.getName()});
            APILogger.catchingIntByAPI(ex);
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    protected synchronized OutputStream getOutputStream() {
        return this.stream;
    }

    protected synchronized void writeInt(String s) throws Exception {
        if (this.out != null) {
            this.out.write(s);
        }
    }

    protected synchronized void flushInt() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected synchronized void openInt() throws IOException {
        if (this.stream != null) {
            if (this.enc != null) {
                try {
                    this.out = new OutputStreamWriter(this.stream, this.enc);
                }
                catch (UnsupportedEncodingException ex) {
                    APILogger.logIntByAPI(400, subLoc + "openInt()]", MSGCollection.LOGGING_MSG_ID_UNSUPPORTED_ENCODING, MSGCollection.LOGGING_MSG_STR_UNSUPPORTED_ENCODING, new String[]{this.enc});
                    this.handleException(ex, 5);
                    this.out = new OutputStreamWriter(this.stream);
                    this.enc = this.out.getEncoding();
                }
            } else {
                this.out = new OutputStreamWriter(this.stream);
                this.enc = this.out.getEncoding();
            }
            this.setStatus(2);
        } else {
            this.out = null;
        }
    }

    protected synchronized void closeInt() throws IOException {
        this.flushInt();
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        this.setStatus(1);
    }

    synchronized void setOutputStream(OutputStream stream) {
        this.stream = stream;
    }
}

