/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.xml;

import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.io.CheckSummerReader;
import com.sap.sdt.util.misc.CheckSummerFactory;
import com.sap.sdt.util.prop.FactoryPropertiesIF;
import com.sap.sdt.util.xml.AbstractXMLElementFactory;
import com.sap.sdt.util.xml.DefaultDTDResolver;
import com.sap.sdt.util.xml.EntityResolverIF;
import com.sap.sdt.util.xml.XMLElementBuilder;
import com.sap.sdt.util.xml.XMLElementConsumerIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLElementProcessorIF;
import com.sap.sdt.util.xml.XMLException;
import com.sap.sdt.util.xml.XMLFactoryProperties;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.xml.sax.InputSource;

class XMLElementDefaultFactory
extends AbstractXMLElementFactory {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/xml/XMLElementDefaultFactory.java#2 $";
    private XMLElementBuilder builder;
    private boolean checksumming = false;
    private XMLFactoryProperties prop;

    public XMLElementDefaultFactory() throws XMLException {
        this.builder = new XMLElementBuilder();
        this.prop = new XMLFactoryProperties();
    }

    public XMLElementDefaultFactory(XMLElementConsumerIF consumer) throws XMLException {
        this.builder = new XMLElementBuilder(consumer);
        this.prop = new XMLFactoryProperties();
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.builder.setIgnoreWhitespace(ignoreWhitespace);
    }

    public void setChecksumming(boolean checksumming) {
        this.checksumming = checksumming;
    }

    public void setEntityResolver(EntityResolverIF entityResolver) {
        this.builder.setEntityResolver(entityResolver);
    }

    public void addElementProcessor(XMLElementProcessorIF proc) {
        this.builder.addElementProcessor(proc);
    }

    public XMLElementIF createXMLElement(InputSource inSource) throws XMLException {
        XMLElementIF element = this.builder.createXMLElement(inSource);
        return element;
    }

    public XMLElementIF createXMLElement(String url) throws XMLException {
        return this.createXMLElement(this.getInputSource(url));
    }

    public XMLElementIF createXMLElement(File file) throws XMLException {
        return this.createXMLElement(this.getInputSource(file));
    }

    public XMLElementIF createXMLElement(InputStream in) throws XMLException {
        return this.createXMLElement(new InputStreamReader(in));
    }

    public XMLElementIF createXMLElement(Reader reader) throws XMLException {
        return this.createXMLElement(this.getInputSource(reader));
    }

    private InputSource getInputSource(String url) throws XMLException {
        return this.getInputSource(new File(url));
    }

    private InputSource getInputSource(File file) throws XMLException {
        try {
            return this.getInputSource(new FileReader(file));
        }
        catch (IOException ioE) {
            throw new XMLException(new FileIOException(ioE));
        }
    }

    private InputSource getInputSource(Reader reader) throws XMLException {
        if (this.checksumming) {
            reader = new CheckSummerReader(reader, CheckSummerFactory.getXMLValidator());
        }
        return new InputSource(reader);
    }

    public XMLFactoryProperties getXMLFactoryProperties() {
        return this.prop;
    }

    public FactoryPropertiesIF getFactoryProperties() {
        return this.prop;
    }

    public void setFactoryProperties(FactoryPropertiesIF prop) {
        this.prop = (XMLFactoryProperties)prop;
        this.builder.setEntityResolver(new DefaultDTDResolver(this));
    }
}

