/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.xml;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.diag.MissingInfoException;
import com.sap.sdt.util.info.IP;
import com.sap.sdt.util.string.SString;
import com.sap.sdt.util.xml.EntityResolverIF;
import com.sap.sdt.util.xml.XMLConstants;
import com.sap.sdt.util.xml.XMLElement;
import com.sap.sdt.util.xml.XMLElementConsumerIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLElementProcessorIF;
import com.sap.sdt.util.xml.XMLException;
import com.sap.sdt.util.xml.XMLParseException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class XMLElementBuilder
extends DefaultHandler
implements XMLElementConsumerIF,
XMLConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/xml/XMLElementBuilder.java#2 $";
    private XMLElementConsumerIF consumer;
    private boolean ignoreWhitespace = false;
    private List elementProcessors = new LinkedList();
    private SAXParser saxParser;
    private Stack elemStack = new Stack();
    private EntityResolverIF entityResolver = null;

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public void addElementProcessor(XMLElementProcessorIF proc) {
        this.elementProcessors.add(proc);
    }

    private void initParser() throws XMLException {
        try {
            String factoryClass;
            try {
                factoryClass = IP.getIP().getE("javax.xml.parsers.SAXParserFactory");
            }
            catch (MissingInfoException e) {
                factoryClass = "com.sap.engine.lib.jaxp.SAXParserFactoryImpl";
            }
            System.setProperty("javax.xml.parsers.SAXParserFactory", factoryClass);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            this.saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException pcE) {
            throw new XMLParseException(pcE);
        }
        catch (SAXException saxE) {
            throw new XMLParseException(saxE);
        }
    }

    XMLElementBuilder() throws XMLException {
        this.consumer = this;
        this.initParser();
    }

    XMLElementBuilder(XMLElementConsumerIF consumer) throws XMLException {
        this.consumer = consumer;
        this.initParser();
    }

    synchronized XMLElementIF createXMLElement(InputSource inSource) throws XMLException {
        XMLElementIF elem;
        try {
            this.elemStack.removeAllElements();
            XMLReader xmlReader = this.saxParser.getXMLReader();
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setEntityResolver(this);
            this.consumer.reset();
            xmlReader.parse(inSource);
            elem = (XMLElementIF)this.elemStack.pop();
        }
        catch (SAXException saxE) {
            throw new XMLParseException(saxE);
        }
        catch (IOException ioE) {
            throw new XMLException(new JavaException(ioE));
        }
        try {
            Iterator it = this.elementProcessors.iterator();
            while (it.hasNext()) {
                XMLElementProcessorIF proc = (XMLElementProcessorIF)it.next();
                elem = proc.process(elem);
            }
        }
        catch (DiagException e) {
            throw new XMLException(e);
        }
        return elem;
    }

    private void setAttrs(XMLElementIF elem, Attributes attrs) {
        int nAttrs = attrs.getLength();
        for (int i = 0; i < nAttrs; ++i) {
            elem.setAttr(attrs.getQName(i), attrs.getValue(i));
        }
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        XMLElement parent = this.elemStack.isEmpty() ? null : (XMLElement)this.elemStack.peek();
        XMLElement elem = new XMLElement(qName);
        this.setAttrs(elem, attrs);
        try {
            this.consumer.startElement(parent, elem);
        }
        catch (DiagException e) {
            throw new SAXException(e);
        }
        this.elemStack.push(elem);
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        String content;
        XMLElement parent;
        XMLElement elem = (XMLElement)this.elemStack.pop();
        if (this.elemStack.isEmpty()) {
            this.elemStack.push(elem);
            parent = null;
        } else {
            parent = (XMLElement)this.elemStack.peek();
        }
        if (this.ignoreWhitespace && (content = elem.getContent()) != null) {
            content = SString.condenseWhitespace(content);
            elem.setContent(content);
        }
        try {
            this.consumer.endElement(parent, elem);
        }
        catch (DiagException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] ch, int start, int len) throws SAXException {
        String content = new String(ch, start, len);
        ((XMLElement)this.elemStack.peek()).addContent(content);
    }

    public void reset() {
    }

    public void startElement(XMLElementIF parent, XMLElementIF child) {
    }

    public void endElement(XMLElementIF parent, XMLElementIF child) {
        if (parent != null) {
            parent.add(child);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource insrc = null;
        if (!this.hasEntityResolver()) return super.resolveEntity(publicId, systemId);
        try {
            InputStream in = this.getEntityResolver().resolveEntity(publicId, systemId);
            if (in == null) return insrc;
            return new InputSource(new InputStreamReader(in));
        }
        catch (XMLException e) {
            throw new SAXException(e);
        }
    }

    protected void setEntityResolver(EntityResolverIF entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected EntityResolverIF getEntityResolver() {
        return this.entityResolver;
    }

    protected boolean hasEntityResolver() {
        return this.entityResolver != null;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }
}

