/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.xml;

import com.sap.sdt.util.xml.PlainXMLWriter;
import com.sap.sdt.util.xml.PrettyXMLWriter;
import com.sap.sdt.util.xml.XMLAmbiguityException;
import com.sap.sdt.util.xml.XMLAttributeNotFoundException;
import com.sap.sdt.util.xml.XMLConstants;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import com.sap.sdt.util.xml.XMLIllegalAttributeValueException;
import com.sap.sdt.util.xml.XMLIllegalContentValueException;
import com.sap.sdt.util.xml.XMLSubElementNotFoundException;
import com.sap.sdt.util.xml.XMLWriterIF;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class XMLElement
implements XMLElementIF,
XMLConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/xml/XMLElement.java#2 $";
    private static final int INDENT_OFFSET = 2;
    private String name = null;
    private String content = null;
    Map attrs = null;
    private List subElements = null;
    private String dtd = null;
    private StringWriter strWriter = null;
    private XMLWriterIF plainWriter = null;

    XMLElement() {
    }

    XMLElement(String name) {
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getContent() {
        return this.content;
    }

    public String getContentTrimmed() {
        if (this.content != null) {
            return this.content.trim();
        }
        return this.content;
    }

    public void setContent(String c) {
        this.content = c;
    }

    public void addContent(String c) {
        this.content = this.content == null ? c : this.content + c;
    }

    public boolean getContentBoolean() throws XMLException {
        if ("true".equalsIgnoreCase(this.getContent())) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.getContent())) {
            return false;
        }
        throw new XMLIllegalContentValueException(this, this.getContent());
    }

    public int getContentInteger() throws XMLException {
        try {
            return Integer.parseInt(this.getContent());
        }
        catch (NumberFormatException nfE) {
            throw new XMLIllegalContentValueException(this, this.getContent());
        }
    }

    public Iterator getAttrNames() {
        if (this.attrs == null) {
            return Collections.EMPTY_SET.iterator();
        }
        return this.attrs.keySet().iterator();
    }

    public XMLElementIF getElement(String name) throws XMLException {
        if (this.subElements != null) {
            int firstInx = -1;
            int lastInx = -1;
            for (int i = 0; i < this.subElements.size(); ++i) {
                XMLElementIF elem = (XMLElementIF)this.subElements.get(i);
                if (!name.equals(elem.getName())) continue;
                if (firstInx == -1) {
                    firstInx = i;
                }
                lastInx = i;
            }
            if (firstInx != lastInx) {
                throw new XMLAmbiguityException(this, name);
            }
            if (firstInx == -1) {
                throw new XMLSubElementNotFoundException(this, name);
            }
            return (XMLElementIF)this.subElements.get(firstInx);
        }
        throw new XMLSubElementNotFoundException(this, name);
    }

    public void setAttr(String name, String value) {
        if (this.attrs == null) {
            this.attrs = new HashMap();
        }
        this.attrs.put(name, value);
    }

    public void removeAttr(String name) {
        if (this.attrs == null) {
            return;
        }
        this.attrs.remove(name);
    }

    public String getAttrString(String name) throws XMLException {
        String value = this.getAttrStringNull(name);
        if (value == null) {
            throw new XMLAttributeNotFoundException(this, name);
        }
        return value;
    }

    public String getAttrStringNull(String name) {
        if (this.attrs == null) {
            return null;
        }
        return (String)this.attrs.get(name);
    }

    public int getAttrInteger(String name) throws XMLException {
        String value = null;
        try {
            value = this.getAttrString(name);
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfE) {
            throw new XMLIllegalAttributeValueException(this, name, value);
        }
    }

    public boolean getAttrBoolean(String name) throws XMLException {
        String value = this.getAttrString(name);
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        throw new XMLIllegalAttributeValueException(this, name, value);
    }

    public boolean isAttributeExisting(String name) {
        boolean exist = false;
        if (this.attrs != null) {
            exist = this.attrs.containsKey(name);
        }
        return exist;
    }

    public Iterator getSubElements() {
        if (this.subElements != null) {
            return this.subElements.listIterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public void add(XMLElementIF elem) {
        if (this.subElements == null) {
            this.subElements = new LinkedList();
        }
        this.subElements.add(elem);
    }

    public void remove(XMLElementIF elem) {
        if (this.subElements == null) {
            return;
        }
        this.subElements.remove(elem);
    }

    public boolean hasSubElement(XMLElementIF elem) {
        return this.subElements != null && this.subElements.contains(elem);
    }

    public boolean hasSubElements() {
        return this.subElements != null;
    }

    public void setDocType(String dtd) {
        this.dtd = dtd;
    }

    public boolean hasDocType() {
        return this.dtd != null;
    }

    public String getDocType() {
        return this.dtd;
    }

    public void toXML(Writer wr) throws XMLException {
        PrettyXMLWriter pW = new PrettyXMLWriter(wr);
        pW.print(this);
    }

    public String toString() {
        String str = null;
        if (this.strWriter == null) {
            this.strWriter = new StringWriter();
            this.plainWriter = new PlainXMLWriter(this.strWriter);
        }
        try {
            this.plainWriter.print(this);
            str = this.strWriter.toString();
        }
        catch (XMLException xmlE) {
            str = super.toString();
        }
        this.strWriter.getBuffer().delete(0, this.strWriter.getBuffer().length());
        return str;
    }

    public boolean equals(Object other) {
        if (!(other instanceof XMLElement)) {
            return false;
        }
        XMLElement elem = (XMLElement)other;
        if (!this.name.equals(elem.name)) {
            return false;
        }
        switch (this.checkForNull(this.dtd, elem.dtd)) {
            case -1: {
                return false;
            }
            case 0: {
                break;
            }
            case 1: {
                if (this.dtd.equals(elem.dtd)) break;
                return false;
            }
        }
        switch (this.checkForNull(this.attrs, elem.attrs)) {
            case -1: {
                return false;
            }
            case 0: {
                break;
            }
            case 1: {
                if (this.attrs.size() == elem.attrs.size()) break;
                return false;
            }
        }
        Iterator it = this.getAttrNames();
        while (it.hasNext()) {
            String aN = (String)it.next();
            try {
                if (this.getAttrString(aN).equals(elem.getAttrString(aN))) continue;
                return false;
            }
            catch (XMLException e) {
                return false;
            }
        }
        switch (this.checkForNull(this.content, elem.content)) {
            case -1: {
                return false;
            }
            case 0: {
                break;
            }
            case 1: {
                if (this.content.equals(elem.content)) break;
                return false;
            }
        }
        LinkedList list = null;
        switch (this.checkForNull(this.subElements, elem.subElements)) {
            case -1: {
                return false;
            }
            case 0: {
                break;
            }
            case 1: {
                if (this.subElements.size() != elem.subElements.size()) {
                    return false;
                }
                list = new LinkedList(elem.subElements);
                break;
            }
        }
        Iterator oit = this.getSubElements();
        while (oit.hasNext()) {
            boolean ok = false;
            XMLElement lse = (XMLElement)oit.next();
            Iterator iit = list.iterator();
            while (iit.hasNext()) {
                XMLElement fse = (XMLElement)iit.next();
                if (!lse.equals(fse)) continue;
                ok = true;
                list.remove(fse);
                break;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    private int checkForNull(Object lhs, Object rhs) {
        if (lhs != null && rhs != null) {
            return 1;
        }
        if (lhs == null && rhs != null) {
            return -1;
        }
        if (lhs != null && rhs == null) {
            return -1;
        }
        return 0;
    }
}

