/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.xml;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileIOException;
import com.sap.sdt.util.io.SFile;
import com.sap.sdt.util.xml.PrettyXMLWriter;
import com.sap.sdt.util.xml.XMLElementDefaultFactory;
import com.sap.sdt.util.xml.XMLElementFactoryIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLFactory;
import com.sap.sdt.util.xml.XMLFromConverterIF;
import com.sap.sdt.util.xml.XMLMissingConverterException;
import com.sap.sdt.util.xml.XMLToConverterIF;
import com.sap.sdt.util.xml.XMLWriterIF;
import com.sap.sdt.util.xml.XmlTraceIF;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

class XMLDefaultFactory
extends XMLFactory
implements XmlTraceIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/xml/XMLDefaultFactory.java#2 $";
    private XMLElementFactoryIF elemFactory = null;
    private XMLFromConverterIF fromConverter = null;
    private XMLToConverterIF toConverter = null;

    XMLDefaultFactory(XMLFromConverterIF from, XMLToConverterIF to) {
        this.fromConverter = from;
        this.toConverter = to;
    }

    private XMLElementFactoryIF getElementFactory() throws DiagException {
        if (this.elemFactory == null) {
            this.elemFactory = new XMLElementDefaultFactory();
        }
        return this.elemFactory;
    }

    private XMLFromConverterIF getFrom() throws XMLMissingConverterException {
        if (this.fromConverter == null) {
            throw new XMLMissingConverterException();
        }
        return this.fromConverter;
    }

    private XMLToConverterIF getTo() throws XMLMissingConverterException {
        if (this.toConverter == null) {
            throw new XMLMissingConverterException();
        }
        return this.toConverter;
    }

    public Object convertFrom(XMLElementIF elem) throws DiagException {
        return this.getFrom().convertFrom(elem);
    }

    public XMLElementIF convertTo(Object obj) throws DiagException {
        return this.getTo().convertTo(obj);
    }

    public Object load(String path) throws DiagException {
        Object[] logP = new String[]{path};
        trc.info(this.getClass(), "Loading  file {0} ...", logP);
        XMLElementIF elem = this.getElementFactory().createXMLElement(path);
        Object obj = this.convertFrom(elem);
        trc.info(this.getClass(), "Finished loading file.", logP);
        return obj;
    }

    public Object load(InputStream inStream) throws DiagException {
        XMLElementIF elem = this.getElementFactory().createXMLElement(inStream);
        Object obj = this.convertFrom(elem);
        return obj;
    }

    public Object load(Reader reader) throws DiagException {
        XMLElementIF elem = this.getElementFactory().createXMLElement(reader);
        Object obj = this.convertFrom(elem);
        return obj;
    }

    public void save(Object obj) throws DiagException {
        this.save(obj, new String());
    }

    public void save(Object obj, String path) throws DiagException {
        Writer writer = null;
        Object[] logP = new String[1];
        writer = path == null ? new PrintWriter(System.out) : SFile.getWriter(path);
        logP[0] = path;
        trc.info(this.getClass(), "Writing  file {0} ...", logP);
        this.save(obj, writer);
        try {
            writer.close();
        }
        catch (IOException ex) {
            throw new FileIOException(ex);
        }
        trc.info(this.getClass(), "Finished writing file.", logP);
    }

    public void save(Object obj, Writer writer) throws DiagException {
        this.convertTo(obj).toXML(writer);
    }

    public XMLWriterIF getWriter(String path) throws DiagException {
        return new PrettyXMLWriter(SFile.getWriter(path));
    }
}

