/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.xml;

import com.sap.sdt.util.xml.AbstractXMLWriter;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.IOException;
import java.io.Writer;

public class PrettyXMLWriter
extends AbstractXMLWriter {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/xml/PrettyXMLWriter.java#2 $";
    private static final int DEFAULT_INDENT = 2;
    private int indent = 2;
    private boolean useCDATA = false;

    public PrettyXMLWriter(int indent) {
        this.indent = indent;
    }

    public PrettyXMLWriter(Writer writer) {
        super(writer);
    }

    public PrettyXMLWriter(Writer writer, int indent) {
        super(writer);
        this.indent = indent;
    }

    public void setUseCDATA(boolean useCDATA) {
        this.useCDATA = useCDATA;
    }

    protected void printHeader() throws IOException {
        this.writer.write(this.getHeader());
    }

    protected void printDocType(XMLElementIF xE) throws IOException {
        this.writer.write("\n" + this.getDocType(xE));
    }

    protected void printStartTag(XMLElementIF xE) throws IOException {
        this.writer.write("\n");
        this.writer.write(this.getIndent());
        this.writer.write(this.getStartTag(xE));
    }

    protected void printContent(XMLElementIF xE) throws IOException {
        String content = xE.getContent();
        if (content != null) {
            if (this.useCDATA) {
                this.writer.write("<![CDATA[" + content + "]]>");
            } else {
                this.writer.write(this.escape(content));
            }
        }
    }

    protected void printEndTag(XMLElementIF xE) throws IOException {
        if (xE.hasSubElements()) {
            this.writer.write("\n" + this.getIndent());
        }
        this.writer.write(this.getEndTag(xE));
    }

    private String getIndent() {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.depth - 1; ++i) {
            this.append(buffer, ' ', this.indent);
        }
        return buffer.toString();
    }

    private void append(StringBuffer buffer, char c, int num) {
        for (int i = 0; i < num; ++i) {
            buffer.append(c);
        }
    }
}

