/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.xml;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.diag.MissingInfoException;
import com.sap.sdt.util.info.IP;
import com.sap.sdt.util.misc.Semaphore;
import com.sap.sdt.util.misc.StringHelper;
import com.sap.sdt.util.xml.XMLConstants;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import com.sap.sdt.util.xml.XMLWriterIF;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public abstract class AbstractXMLWriter
implements XMLWriterIF,
XMLConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/xml/AbstractXMLWriter.java#2 $";
    protected Writer writer;
    protected int depth = 0;
    private Semaphore mutex = null;

    public AbstractXMLWriter() {
        this(new PrintWriter(System.out));
    }

    public AbstractXMLWriter(Writer _writer) {
        this.writer = _writer;
        this.mutex = new Semaphore();
    }

    public void print(XMLElementIF xE) throws XMLException {
        this.mutex.down();
        try {
            this.printHeader();
            if (xE.hasDocType()) {
                this.printDocType(xE);
            }
            this.printElement(xE);
        }
        catch (IOException e) {
            this.cleanUp();
            throw new XMLException(new JavaException(e));
        }
        this.mutex.up();
    }

    public void close() throws XMLException {
        this.mutex.down();
        try {
            this.writer.close();
        }
        catch (IOException e) {
            this.cleanUp();
            throw new XMLException(new JavaException(e));
        }
        this.mutex.up();
    }

    protected void printElement(XMLElementIF xE) throws IOException {
        ++this.depth;
        this.printStartTag(xE);
        this.printContent(xE);
        Iterator it = xE.getSubElements();
        while (it.hasNext()) {
            XMLElementIF subElem = (XMLElementIF)it.next();
            this.printElement(subElem);
        }
        this.printEndTag(xE);
        --this.depth;
    }

    protected abstract void printHeader() throws IOException;

    protected abstract void printDocType(XMLElementIF var1) throws IOException;

    protected abstract void printStartTag(XMLElementIF var1) throws IOException;

    protected abstract void printContent(XMLElementIF var1) throws IOException;

    protected abstract void printEndTag(XMLElementIF var1) throws IOException;

    protected String getHeader() {
        String header = null;
        try {
            header = IP.getIP().getE("xml.file.header");
        }
        catch (MissingInfoException e) {
            header = "<?xml version=\"1.0\"?>";
        }
        return header;
    }

    protected String getDocType(XMLElementIF xE) {
        StringBuffer docType = new StringBuffer();
        docType.append("<!DOCTYPE").append(" ");
        docType.append(xE.getName()).append(" ");
        docType.append("SYSTEM").append(" '");
        docType.append(xE.getDocType()).append("'>");
        return docType.toString();
    }

    protected String getStartTag(XMLElementIF xE) {
        StringBuffer tag = new StringBuffer();
        tag.append("<").append(xE.getName());
        Iterator it = xE.getAttrNames();
        while (it.hasNext()) {
            String name = (String)it.next();
            tag.append(" ").append(name).append("=\"");
            try {
                tag.append(this.escape(xE.getAttrString(name)));
            }
            catch (XMLException xmlE) {
                // empty catch block
            }
            tag.append("\"");
        }
        tag.append(">");
        return tag.toString();
    }

    protected String getEndTag(XMLElementIF xE) {
        StringBuffer tag = new StringBuffer();
        tag.append("</").append(xE.getName()).append(">");
        return tag.toString();
    }

    protected String escape(String text) {
        StringBuffer escapedText = StringHelper.replace(text, '&', "&amp;");
        StringHelper.replace(escapedText, '<', "&lt;");
        StringHelper.replace(escapedText, '>', "&gt;");
        StringHelper.replace(escapedText, '\'', "&apos;");
        StringHelper.replace(escapedText, '\"', "&quot;");
        return escapedText.toString();
    }

    private void cleanUp() {
        this.depth = 0;
        this.mutex.up();
    }
}

