/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.vers;

import com.sap.sdt.util.vers.VersionConstantsIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionNotComparableException;
import com.sap.sdt.util.vers.VersionRangeIF;
import com.sap.sdt.util.vers.XMLConstantsIF;

public class VersionRange
implements VersionRangeIF,
XMLConstantsIF,
VersionConstantsIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/vers/VersionRange.java#2 $";
    private int type = -1;
    private VersionIF lowLimit = null;
    private VersionIF highLimit = null;

    public VersionRange(int _type, String low, String high) {
        this.lowLimit = VersionFactory.createVersion(low, _type);
        this.highLimit = VersionFactory.createVersion(high, _type);
        this.type = _type;
    }

    public VersionRange(VersionIF low, VersionIF high) {
        this.type = -1;
        if (low == null) {
            this.lowLimit = null;
        } else {
            this.lowLimit = low.copy();
            this.type = this.lowLimit.getType();
        }
        if (high == null) {
            this.highLimit = null;
        } else {
            this.highLimit = high.copy();
            this.type = this.highLimit.getType();
        }
    }

    public VersionRange(VersionIF single) {
        this.type = -1;
        if (single == null) {
            return;
        }
        this.lowLimit = (VersionIF)single.clone();
        this.highLimit = (VersionIF)single.clone();
        this.type = this.lowLimit.getType();
    }

    private int compareLow(VersionIF other) throws VersionNotComparableException {
        if (this.lowLimit == null) {
            return 0;
        }
        return this.lowLimit.compare(other);
    }

    private int compareHigh(VersionIF other) throws VersionNotComparableException {
        if (this.highLimit == null) {
            return 0;
        }
        return this.highLimit.compare(other);
    }

    public VersionIF getLowLimit() {
        return this.lowLimit;
    }

    public VersionIF getHighLimit() {
        return this.highLimit;
    }

    public boolean contains(VersionIF version) throws VersionNotComparableException {
        return this.compareLow(version) <= 0 && this.compareHigh(version) >= 0;
    }

    public boolean isAbove(VersionIF version) throws VersionNotComparableException {
        return this.compareHigh(version) < 0;
    }

    public boolean isBelow(VersionIF version) throws VersionNotComparableException {
        return this.compareLow(version) > 0;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "[" + (this.lowLimit != null ? ((Object)this.lowLimit).toString() : "-inf") + "," + (this.highLimit != null ? ((Object)this.highLimit).toString() : "+inf") + "]";
    }
}

