/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.vers;

import com.sap.sdt.util.vers.DBDB4VersionImpl;
import com.sap.sdt.util.vers.DBIdC;
import com.sap.sdt.util.vers.DBVersion;
import com.sap.sdt.util.vers.DecimalVersion;
import com.sap.sdt.util.vers.JavaVersion;
import com.sap.sdt.util.vers.OSIdC;
import com.sap.sdt.util.vers.OSVersion;
import com.sap.sdt.util.vers.SAPVersion;
import com.sap.sdt.util.vers.VersionConstantsIF;
import com.sap.sdt.util.vers.VersionFormatException;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionIdC;
import com.sap.sdt.util.vers.VersionRange;
import com.sap.sdt.util.vers.VersionRangeIF;
import com.sap.sdt.util.vers.VersionTypeFormatException;
import com.sap.sdt.util.vers.XMLConstantsIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Iterator;

public class VersionFactory
implements VersionConstantsIF,
XMLConstantsIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/vers/VersionFactory.java#3 $";

    public static VersionIF createVersion(String vers) {
        return VersionFactory.createVersion(vers, 0);
    }

    public static VersionIF createVersion(String vers, String typeStr) {
        int type = VersionIdC.m.getInt(typeStr.toUpperCase());
        return VersionFactory.createVersion(vers, type);
    }

    public static VersionIF createVersion(String vers, int type) {
        try {
            return VersionFactory.createVersionE(vers, type);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createVersionE(String vers, String typeStr) throws VersionFormatException {
        int type = VersionIdC.m.getInt(typeStr.toUpperCase());
        return VersionFactory.createVersionE(vers, type);
    }

    public static VersionIF createVersionE(String vers, int type) throws VersionFormatException {
        if (type >= 100 && type < 110) {
            return VersionFactory.createOsVersion(vers, type);
        }
        if (type >= 200 && type < 207) {
            return VersionFactory.createDbVersion(vers, type);
        }
        switch (type) {
            case 0: {
                return new DecimalVersion(vers);
            }
            case 1: {
                return new SAPVersion(vers);
            }
            case 2: {
                return new JavaVersion(vers);
            }
        }
        throw new VersionTypeFormatException(type);
    }

    public static VersionIF createVersion(XMLElementIF xElem) {
        try {
            return VersionFactory.createVersionE(xElem);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createVersionE(XMLElementIF xElem) throws VersionFormatException {
        String type = null;
        try {
            type = xElem.getAttrString("type");
        }
        catch (XMLException ex) {
            throw new VersionTypeFormatException(xElem.getName());
        }
        return VersionFactory.createVersionE(xElem, type);
    }

    public static VersionIF createVersionE(XMLElementIF xElem, String type) throws VersionFormatException {
        String tagName = xElem.getName();
        String value = xElem.getContent();
        if ("OsVersion".equals(tagName)) {
            return VersionFactory.createOsVersionE(value, type);
        }
        if ("DbVersion".equals(tagName)) {
            return VersionFactory.createDbVersionE(value, type);
        }
        if ("SapVersion".equals(tagName)) {
            return VersionFactory.createSapVersionE(value);
        }
        if ("JavaVersion".equals(tagName)) {
            return VersionFactory.createJavaVersionE(value);
        }
        return VersionFactory.createVersion(value, type);
    }

    public static VersionIF createJavaVersion(String vers) {
        try {
            return VersionFactory.createJavaVersionE(vers);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createJavaVersionE(String vers) throws VersionFormatException {
        return new JavaVersion(vers);
    }

    public static VersionIF createSapVersion(String vers) {
        try {
            return VersionFactory.createSapVersionE(vers);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createSapVersionE(String vers) throws VersionFormatException {
        return new SAPVersion(vers);
    }

    public static VersionIF createDbVersion(String vers, int type) {
        try {
            return VersionFactory.createDbVersionE(vers, type);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createDbVersion(String vers, String typeStr) {
        try {
            return VersionFactory.createDbVersionE(vers, typeStr);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createDbVersionE(String vers, String typeStr) throws VersionFormatException {
        int type = DBIdC.m.getInt(typeStr.toUpperCase());
        return VersionFactory.createDbVersion(vers, type);
    }

    public static VersionIF createDbVersionE(String vers, int type) throws VersionFormatException {
        if (type < 200 && type >= 207) {
            throw new VersionTypeFormatException(type);
        }
        return new DBVersion(vers, type);
    }

    static VersionIF createDbVersionImplE(String vers, int type) throws VersionFormatException {
        if (type < 200 && type >= 207) {
            throw new VersionTypeFormatException(type);
        }
        switch (type) {
            case 200: {
                return new DecimalVersion(vers);
            }
            case 201: {
                return new DBDB4VersionImpl(vers);
            }
            case 202: {
                return new DecimalVersion(vers);
            }
            case 205: {
                return new DecimalVersion(vers);
            }
            case 206: {
                return new DecimalVersion(vers);
            }
            case 204: {
                return new DecimalVersion(vers);
            }
            case 203: {
                throw new VersionTypeFormatException(type);
            }
        }
        throw new VersionTypeFormatException(type);
    }

    public static VersionIF createOsVersion(String vers, int type) {
        try {
            return VersionFactory.createOsVersionE(vers, type);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createOsVersion(String vers, String typeStr) {
        try {
            return VersionFactory.createOsVersionE(vers, typeStr);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionIF createOsVersionE(String vers, String typeStr) throws VersionFormatException {
        int type = OSIdC.m.getInt(typeStr.toUpperCase());
        return VersionFactory.createOsVersion(vers, type);
    }

    public static VersionIF createOsVersionE(String vers, int type) throws VersionFormatException {
        if (type < 100 && type >= 110) {
            throw new VersionTypeFormatException(type);
        }
        return new OSVersion(vers, type);
    }

    public static VersionRangeIF createVersionRange(XMLElementIF xElem) {
        try {
            return VersionFactory.createVersionRangeE(xElem);
        }
        catch (VersionFormatException ex) {
            return null;
        }
    }

    public static VersionRangeIF createVersionRangeE(XMLElementIF xElem) throws VersionFormatException {
        String name = xElem.getName();
        if ("SapRange".equals(name) || "VersionRange".equals(name) || "JavaRange".equals(name) || "DbRange".equals(name) || "OsRange".equals(name)) {
            return VersionFactory.createVersionRangeFromXml(xElem);
        }
        if ("SapVersion".equals(name) || "Version".equals(name) || "JavaVersion".equals(name) || "DbVersion".equals(name) || "OsVersion".equals(name)) {
            VersionIF vers = VersionFactory.createVersion(xElem);
            return new VersionRange(vers, vers);
        }
        throw new VersionTypeFormatException(name);
    }

    private static VersionRangeIF createVersionRangeFromXml(XMLElementIF rootElem) throws VersionFormatException {
        XMLElementIF lowElem = null;
        XMLElementIF highElem = null;
        String name = rootElem.getName();
        String type = null;
        String lowValue = null;
        String highValue = null;
        try {
            type = rootElem.getAttrString("type");
        }
        catch (XMLException ex) {
            if ("SapRange".equals(name)) {
                type = "SAP";
            }
            if ("VersionRange".equals(name)) {
                type = "DECIMAL";
            }
            if ("JavaRange".equals(name)) {
                type = "JAVA";
            }
            throw new VersionTypeFormatException(name);
        }
        Iterator it = rootElem.getSubElements();
        if (it.hasNext()) {
            lowElem = (XMLElementIF)it.next();
            lowValue = lowElem.getContent();
        }
        if (it.hasNext()) {
            highElem = (XMLElementIF)it.next();
            highValue = highElem.getContent();
        }
        VersionIF low = VersionFactory.createVersionE(lowValue, type);
        VersionIF high = VersionFactory.createVersionE(highValue, type);
        return new VersionRange(low, high);
    }
}

