/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.vers;

import com.sap.sdt.util.vers.AbstractVersion;
import com.sap.sdt.util.vers.VersionContentFormatException;
import com.sap.sdt.util.vers.VersionFormatException;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionNotComparableException;

public class SAPVersion
extends AbstractVersion {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/vers/SAPVersion.java#3 $";
    private static String PATTERN = "[1-9][.][0-9][0-9A-Z]";
    private int major = 0;
    private int minor = 0;
    private char chara = (char)32;
    private static final char versSeparator = '.';

    public SAPVersion(String vers) throws VersionFormatException {
        char[] v = SAPVersion.splitter(vers);
        this.major = Character.getNumericValue(v[0]);
        this.minor = Character.getNumericValue(v[1]);
        this.chara = v[2];
    }

    public SAPVersion(SAPVersion vers) {
        this.major = vers.major;
        this.minor = vers.minor;
        this.chara = vers.chara;
    }

    public String toString() {
        return "" + this.major + this.minor + this.chara;
    }

    public String toDotString() {
        return "" + this.major + '.' + this.minor + this.chara;
    }

    public int compare(VersionIF otherV) throws VersionNotComparableException {
        if (!(otherV instanceof SAPVersion)) {
            throw new VersionNotComparableException(this, otherV);
        }
        if (otherV.getType() != 1) {
            throw new VersionNotComparableException(this, otherV);
        }
        SAPVersion other = (SAPVersion)otherV;
        return this.compare(other);
    }

    public int compare(SAPVersion other) {
        if (this.major < other.major) {
            return -3;
        }
        if (this.major > other.major) {
            return 3;
        }
        if (this.minor < other.minor) {
            return -2;
        }
        if (this.minor > other.minor) {
            return 2;
        }
        if (this.chara == '0') {
            if (other.chara == '0') {
                return 0;
            }
            return -1;
        }
        int cmp = this.compChar(this.chara, other.chara);
        if (cmp < 0) {
            return -1;
        }
        if (cmp > 0) {
            return 1;
        }
        return 0;
    }

    private int compChar(char a, char b) {
        if (a == b) {
            return 0;
        }
        if (a == '0') {
            return -1;
        }
        if (b == '0') {
            return 1;
        }
        if (a >= '1' && b <= '9') {
            if (b >= '1' && b <= '9') {
                return a < b ? -1 : 1;
            }
            return -1;
        }
        if (b >= '1' && b <= '9') {
            return 1;
        }
        return a < b ? -1 : 1;
    }

    public int getType() {
        return 1;
    }

    public String getTypeStr() {
        return "SAP";
    }

    private static char[] splitter(String vers) throws VersionFormatException {
        char[] v = new char[3];
        int inx = 0;
        if (vers == null) {
            throw new VersionContentFormatException("null", "SAP", PATTERN);
        }
        if (vers.length() < 3) {
            throw new VersionContentFormatException(vers, "SAP", PATTERN);
        }
        v[0] = vers.charAt(inx);
        v[1] = vers.charAt(++inx);
        ++inx;
        if (v[1] == '.') {
            if (vers.length() < 4) {
                throw new VersionContentFormatException(vers, "SAP", PATTERN);
            }
            v[1] = vers.charAt(inx);
            ++inx;
        }
        v[2] = vers.charAt(inx);
        ++inx;
        return v;
    }

    public VersionIF copy() {
        return new SAPVersion(this);
    }
}

