/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.vers;

import com.sap.sdt.util.string.SString;
import com.sap.sdt.util.vers.AbstractVersion;
import com.sap.sdt.util.vers.DecimalVersion;
import com.sap.sdt.util.vers.VersionContentFormatException;
import com.sap.sdt.util.vers.VersionFormatException;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionNotComparableException;

public class JavaVersion
extends AbstractVersion {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/vers/JavaVersion.java#2 $";
    private static String PATTERN = "[1-9][0-9.]*[0-9]*_[0-9]*";
    private static final char[] ALLOWED = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '.'};
    private DecimalVersion decVers = null;
    private String extension = null;
    private boolean finalDot = false;

    public JavaVersion(String vers) throws VersionFormatException {
        if (vers == null) {
            throw new VersionContentFormatException("null", this.getTypeStr(), PATTERN);
        }
        int extOffset = SString.getFirstDifferent(vers, ALLOWED);
        if (extOffset < 1) {
            throw new VersionContentFormatException(vers, this.getTypeStr(), PATTERN);
        }
        if (extOffset >= vers.length()) {
            this.decVers = new DecimalVersion(vers);
            this.extension = "";
            return;
        }
        if (vers.charAt(extOffset) != '_') {
            throw new VersionContentFormatException(vers, this.getTypeStr(), PATTERN);
        }
        if (vers.charAt(extOffset - 1) == '.') {
            if (extOffset > 2 && vers.charAt(extOffset - 2) == '.') {
                throw new VersionContentFormatException(vers, this.getTypeStr(), PATTERN);
            }
            this.finalDot = true;
            String decStr = vers.substring(0, extOffset - 1);
            this.decVers = new DecimalVersion(decStr);
            this.extension = vers.substring(extOffset, vers.length());
            return;
        }
        String decStr = vers.substring(0, extOffset);
        this.decVers = new DecimalVersion(decStr);
        this.extension = vers.substring(extOffset, vers.length());
    }

    public JavaVersion(JavaVersion other) {
        this.decVers = (DecimalVersion)other.decVers.clone();
        this.extension = other.extension;
    }

    public int compare(VersionIF other) throws VersionNotComparableException {
        JavaVersion otherV = null;
        try {
            otherV = (JavaVersion)other;
        }
        catch (ClassCastException ex) {
            throw new VersionNotComparableException(this, other);
        }
        int cmp = this.decVers.compare(otherV.decVers);
        if (cmp != 0) {
            return cmp;
        }
        return this.extension.compareToIgnoreCase(otherV.extension);
    }

    public VersionIF copy() {
        return new JavaVersion(this);
    }

    public String toString() {
        return this.decVers.toString() + (this.finalDot ? "." : "") + this.extension;
    }

    public int getType() {
        return 2;
    }

    public String getTypeStr() {
        return "JAVA";
    }
}

