/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.vers;

import com.sap.sdt.util.string.SString;
import com.sap.sdt.util.vers.AbstractVersion;
import com.sap.sdt.util.vers.VersionContentFormatException;
import com.sap.sdt.util.vers.VersionFormatException;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.vers.VersionNotComparableException;

public class DecimalVersion
extends AbstractVersion {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/vers/DecimalVersion.java#3 $";
    private static final String PATTERN = "[0-9.]*";
    private int[] subVersion = null;
    private static char versSeparator = (char)46;

    public DecimalVersion(String vers) throws VersionFormatException {
        if (vers == null) {
            throw new VersionContentFormatException("null", this.getTypeStr(), PATTERN);
        }
        try {
            this.subVersion = DecimalVersion.splitter(vers, versSeparator);
        }
        catch (NumberFormatException ex) {
            throw new VersionContentFormatException(vers, this.getTypeStr(), PATTERN);
        }
    }

    public DecimalVersion(String vers, String newName) throws VersionFormatException {
        this(vers);
        this.setName(newName);
    }

    public DecimalVersion(DecimalVersion other) {
        int max = other.subVersion.length;
        this.subVersion = new int[max];
        for (int i = 0; i < max; ++i) {
            this.subVersion[i] = other.subVersion[i];
        }
    }

    public static boolean isValid(String vers) {
        if (vers == null) {
            return false;
        }
        try {
            DecimalVersion.splitter(vers, versSeparator);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public int compare(VersionIF otherV) throws VersionNotComparableException {
        if (!(otherV instanceof DecimalVersion)) {
            throw new VersionNotComparableException(this, otherV);
        }
        DecimalVersion other = (DecimalVersion)otherV;
        return this.compare(other);
    }

    public int compare(DecimalVersion other) {
        if (other.getSize() != this.getSize()) {
            int res = this.compareSloppy(other);
            if (res != 0) {
                return res;
            }
            if (this.getSize() < other.getSize()) {
                return -1;
            }
            if (this.getSize() > other.getSize()) {
                return 1;
            }
            return 0;
        }
        return this.compareSloppy(other);
    }

    public int compareSloppy(VersionIF otherV) throws VersionNotComparableException {
        if (!(otherV instanceof DecimalVersion)) {
            throw new VersionNotComparableException(this, otherV);
        }
        DecimalVersion other = (DecimalVersion)otherV;
        return this.compareSloppy(other);
    }

    public int compareSloppy(DecimalVersion other) {
        int min = this.getSize();
        if (other.getSize() < min) {
            min = other.getSize();
        }
        for (int i = 0; i < min; ++i) {
            if (this.subVersion[i] < other.subVersion[i]) {
                return -(min - i);
            }
            if (this.subVersion[i] <= other.subVersion[i]) continue;
            return min - i;
        }
        return 0;
    }

    public int getType() {
        return 0;
    }

    public String getTypeStr() {
        return "DECIMAL";
    }

    public String toString() {
        String out = "";
        for (int i = 0; i < this.subVersion.length - 1; ++i) {
            out = out + this.subVersion[i] + ".";
        }
        out = out + this.subVersion[this.subVersion.length - 1];
        return out;
    }

    public int getSize() {
        if (this.subVersion == null) {
            return 0;
        }
        return this.subVersion.length;
    }

    private static int[] splitter(String vers, char versS) throws NumberFormatException {
        if (vers == null || vers.length() <= 0) {
            throw new NumberFormatException();
        }
        String[] subS = SString.getSubStrings(vers, versS);
        if (subS.length <= 0) {
            throw new NumberFormatException();
        }
        int maxInx = subS.length;
        if (subS[maxInx - 1].length() <= 0) {
            if (maxInx > 1) {
                --maxInx;
            } else {
                throw new NumberFormatException();
            }
        }
        int[] subV = new int[maxInx];
        for (int i = 0; i < maxInx; ++i) {
            subV[i] = Integer.parseInt(subS[i]);
        }
        return subV;
    }

    public VersionIF copy() {
        return new DecimalVersion(this);
    }

    public Object clone() {
        return new DecimalVersion(this);
    }
}

