/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.vers;

import com.sap.sdt.util.vers.PackageInfoIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractPackageInfo
implements PackageInfoIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/vers/AbstractPackageInfo.java#2 $";
    private String packageName = null;
    private VersionIF version = null;
    private List subPackList = null;

    public AbstractPackageInfo(String versStr) {
        this(VersionFactory.createVersion(versStr, 0));
    }

    public AbstractPackageInfo(VersionIF vers) {
        this.version = vers;
    }

    public AbstractPackageInfo(String name, String versStr) {
        this(name, VersionFactory.createVersion(versStr, 0));
    }

    public AbstractPackageInfo(String name, VersionIF vers) {
        this.packageName = name;
        this.version = vers;
    }

    public String getPackageName() {
        return this.packageName;
    }

    protected void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public VersionIF getVersion() {
        return (VersionIF)this.version.clone();
    }

    public List getSubPackageInfoList() {
        if (this.subPackList == null) {
            return new LinkedList();
        }
        return this.subPackList;
    }

    public void addSubPackageInfo(PackageInfoIF packageInfo) {
        if (this.subPackList == null) {
            this.subPackList = new LinkedList();
        }
        this.subPackList.add(packageInfo);
    }

    public void appendInfo(List mList) {
        String msg = "Package " + this.packageName + ": version " + ((Object)this.version).toString();
        mList.add(msg);
        if (this.subPackList == null) {
            return;
        }
        PackageInfoIF pi = null;
        Iterator it = this.subPackList.iterator();
        while (it.hasNext()) {
            pi = (PackageInfoIF)it.next();
            pi.appendInfo(mList);
        }
    }
}

