/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.dialog.InputField;
import com.sap.sdt.util.dialog.RadioButton;
import com.sap.sdt.util.dialog.RadioButtonGroup;
import com.sap.sdt.util.value.table.TableModel;
import java.text.DecimalFormat;
import java.util.Arrays;

public class TableRenderer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/table/TableRenderer.java#2 $";
    private static final String BAR = "|";
    private TableModel tableModel;
    private RadioButton editCell;
    private RadioButton exit;

    public TableRenderer(TableModel tableModel) {
        this.tableModel = tableModel;
    }

    public InputField getRowIndexInputField() {
        return this.getIndexInputField(this.tableModel.getTable().size(), "Enter the row index");
    }

    public InputField getColumnIndexInputField() {
        return this.getIndexInputField(this.tableModel.getColumnCount(), "Enter the column index");
    }

    private InputField getIndexInputField(int length, String label) {
        Long indexValue = new Long(0L);
        InputField indexField = new InputField(indexValue, label);
        Object[] indexes = new String[length];
        for (int i = 0; i < indexes.length; ++i) {
            indexes[i] = "" + i;
        }
        indexField.setPossibleValues(indexes);
        return indexField;
    }

    public RadioButtonGroup getEditOptions() {
        this.editCell = new RadioButton(Boolean.FALSE, "edit a cell");
        this.exit = new RadioButton(Boolean.TRUE, "exit");
        RadioButtonGroup editOptions = new RadioButtonGroup();
        editOptions.add(this.editCell);
        editOptions.add(this.exit);
        return editOptions;
    }

    public boolean isEditCellOption(RadioButtonGroup editOptions) {
        return editOptions.getSelection().equals(this.editCell);
    }

    public boolean isExitOption(RadioButtonGroup editOptions) {
        return editOptions.getSelection().equals(this.exit);
    }

    public String getStringTableText() {
        int i;
        int numberColumns = this.tableModel.getColumnCount();
        DecimalFormat df = new DecimalFormat("000");
        int[] columnWidth = this.getColumnWidth();
        StringBuffer b = new StringBuffer("Row ");
        for (i = 0; i < numberColumns; ++i) {
            b.append(this.getCellText(this.tableModel.getColumnName(i), columnWidth[i]));
        }
        b.append('\n');
        b.append(this.append("", 3, '-') + ' ');
        for (i = 0; i < numberColumns; ++i) {
            String s = "(" + i + ")";
            s = this.append(s, columnWidth[i], '-');
            b.append(this.getCellText(s));
        }
        b.append('\n');
        for (int rowIndex = 0; rowIndex < this.tableModel.getRowCount(); ++rowIndex) {
            b.append(df.format(rowIndex) + " ");
            for (int columnIndex = 0; columnIndex < numberColumns; ++columnIndex) {
                Object value = this.tableModel.getValueAt(rowIndex, columnIndex);
                b.append(this.getCellText(value, columnWidth[columnIndex]));
            }
            b.append('\n');
        }
        return b.toString();
    }

    private int[] getColumnWidth() {
        int numberColumns = this.tableModel.getColumnCount();
        int[] columnWidth = new int[numberColumns];
        for (int i = 0; i < numberColumns; ++i) {
            columnWidth[i] = this.tableModel.getColumnName(i).length();
        }
        for (int rowIndex = 0; rowIndex < this.tableModel.getRowCount(); ++rowIndex) {
            for (int columnIndex = 0; columnIndex < numberColumns; ++columnIndex) {
                int len;
                Object value = this.tableModel.getValueAt(rowIndex, columnIndex);
                int n = len = value == null ? 0 : value.toString().length();
                if (columnWidth[columnIndex] >= len) continue;
                columnWidth[columnIndex] = len;
            }
        }
        return columnWidth;
    }

    private String getCellText(Object o) {
        String s = o == null ? "" : o.toString();
        return "| " + s + ' ';
    }

    private String getCellText(Object o, int len) {
        String s = o == null ? "" : o.toString();
        return "| " + this.appendSpaces(s, len) + ' ';
    }

    private String appendSpaces(String s, int len) {
        return this.append(s, len, ' ');
    }

    private String append(String s, int len, char c) {
        String result;
        String string = result = s == null ? "" : s;
        if (result.length() < len) {
            int fillerLength = len - result.length();
            char[] filler = new char[fillerLength];
            Arrays.fill(filler, c);
            result = result + String.valueOf(filler);
        }
        return result;
    }
}

