/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.value.table.NoSuchRowException;
import com.sap.sdt.util.value.table.TableDisplayDescription;
import com.sap.sdt.util.value.table.TableIF;
import com.sap.sdt.util.value.table.TableRowIF;
import com.sap.sdt.util.value.table.TableRowIteratorIF;
import javax.swing.table.AbstractTableModel;

public class TableModel
extends AbstractTableModel
implements javax.swing.table.TableModel {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/table/TableModel.java#2 $";
    private TableIF table;
    private TableDisplayDescription display;
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableModel(TableIF table, TableDisplayDescription display) {
        this.table = table;
        this.display = display;
    }

    public TableIF getTable() {
        return this.table;
    }

    public void updateTable(TableIF table) {
        this.table = table;
        super.fireTableDataChanged();
    }

    public int getColumnCount() {
        return this.display.getNumberDisplayColumns();
    }

    public int getRowCount() {
        return this.table.size();
    }

    public String getColumnName(int columnIndex) {
        return this.display.getDisplayColumnHeading(columnIndex);
    }

    public Class getColumnClass(int columnIndex) {
        return this.display.getDisplayColumnType(columnIndex);
    }

    public int findColumn(String columnName) {
        return this.display.getDisplayColumnIndex(columnName);
    }

    public boolean isEditable() {
        return this.display.isDisplayEditable();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.display.isDisplayColumnEditable(columnIndex);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        TableRowIF row = this.getRowAt(rowIndex);
        return row.get(this.display.getTableColumnIndex(columnIndex));
    }

    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        block3: {
            if (this.isCellEditable(rowIndex, columnIndex)) {
                TableRowIF row = this.getRowAt(rowIndex);
                try {
                    this.table.setValue(row.getKey(), this.display.getTableColumnIndex(columnIndex), value);
                    super.fireTableCellUpdated(rowIndex, columnIndex);
                }
                catch (NoSuchRowException e) {
                    if ($assertionsDisabled) break block3;
                    throw new AssertionError();
                }
            }
        }
    }

    private TableRowIF getRowAt(int rowIndex) {
        TableRowIteratorIF it = this.table.rowIterator();
        int currentRow = 0;
        while (it.hasNext()) {
            TableRowIF row = it.next();
            if (rowIndex == currentRow) {
                return row;
            }
            ++currentRow;
        }
        return null;
    }

    static {
        $assertionsDisabled = !TableModel.class.desiredAssertionStatus();
    }
}

