/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.value.table.TableColumnException;
import com.sap.sdt.util.value.table.TableDescriptionIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.ArrayList;
import java.util.Iterator;

public class TableDisplayDescription {
    private ColumnDescription[] columns;

    public TableDisplayDescription(TableDescriptionIF desc) {
        this.columns = new ColumnDescription[desc.getNumberColumns()];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = new ColumnDescription(i, desc.getColumnName(i), desc.getColumnType(i));
        }
    }

    public TableDisplayDescription(XMLElementIF elem) throws WrongSyntaxException {
        this.deserialize(elem);
    }

    public void update(TableDescriptionIF desc) throws TableColumnException {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!desc.hasColumnName(this.columns[i].getName())) {
                throw new TableColumnException(this.columns[i].getName());
            }
            int columnIndex = desc.getColumnIndex(this.columns[i].getName());
            this.columns[i].setIndex(columnIndex);
            Class type = desc.getColumnType(columnIndex);
            this.columns[i].setType(type);
            if (columnIndex >= desc.getNumberKeyColumns()) continue;
            this.columns[i].setEditable(false);
        }
    }

    protected void deserialize(XMLElementIF elem) throws WrongSyntaxException {
        String tokenExpected = "DISPLAY";
        String tokenFound = elem.getName();
        if (!tokenExpected.equals(tokenFound)) {
            throw new WrongSyntaxException(tokenFound, tokenExpected);
        }
        ArrayList<ColumnDescription> list = new ArrayList<ColumnDescription>();
        Iterator it = elem.getSubElements();
        while (it.hasNext()) {
            boolean editable;
            String heading;
            tokenExpected = "ColumnName";
            XMLElementIF subElem = (XMLElementIF)it.next();
            tokenFound = subElem.getName();
            if (!tokenExpected.equals(tokenFound)) {
                throw new WrongSyntaxException(tokenFound, tokenExpected);
            }
            String name = subElem.getContentTrimmed();
            try {
                heading = subElem.getAttrString("heading");
            }
            catch (XMLException e) {
                heading = name;
            }
            try {
                editable = subElem.getAttrBoolean("editable");
            }
            catch (XMLException e) {
                editable = true;
            }
            ColumnDescription colDesc = new ColumnDescription(name, heading, editable);
            list.add(colDesc);
        }
        this.columns = new ColumnDescription[list.size()];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = (ColumnDescription)list.get(i);
        }
    }

    public XMLElementIF serialize(XMLElementIF rootElem) {
        XMLElementIF displayElem = XMLAdmin.createXMLElement();
        displayElem.setName("DISPLAY");
        for (int i = 0; i < this.columns.length; ++i) {
            XMLElementIF columnElem = XMLAdmin.createXMLElement();
            columnElem.setName("ColumnName");
            columnElem.setContent(this.columns[i].getName());
            columnElem.setAttr("heading", this.columns[i].getHeading());
            columnElem.setAttr("editable", Boolean.toString(this.columns[i].isEditable()));
            displayElem.add(columnElem);
        }
        rootElem.add(displayElem);
        return rootElem;
    }

    public int getNumberDisplayColumns() {
        return this.columns.length;
    }

    public String getDisplayColumnHeading(int columnIndex) {
        return this.columns[columnIndex].getHeading();
    }

    public Class getDisplayColumnType(int columnIndex) {
        return this.columns[columnIndex].getType();
    }

    public boolean isDisplayColumnEditable(int columnIndex) {
        return this.columns[columnIndex].isEditable();
    }

    public boolean isDisplayEditable() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.isDisplayColumnEditable(i)) continue;
            return true;
        }
        return false;
    }

    public int getDisplayColumnIndex(String columnHeading) {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!columnHeading.equals(this.columns[i].getHeading())) continue;
            return i;
        }
        return -1;
    }

    public int getTableColumnIndex(int columnIndex) {
        return this.columns[columnIndex].getIndex();
    }

    private class ColumnDescription {
        private int index;
        private String name;
        private Class type;
        private String heading;
        private boolean editable;

        ColumnDescription(int index, String name, Class type) {
            this(index, name, type, name, true);
        }

        ColumnDescription(String name, String heading, boolean editable) {
            this(-1, name, null, heading, editable);
        }

        public ColumnDescription(int index, String name, Class type, String heading, boolean editable) {
            this.index = index;
            this.name = name;
            this.type = type;
            this.heading = heading;
            this.editable = editable;
        }

        int getIndex() {
            return this.index;
        }

        void setIndex(int index) {
            this.index = index;
        }

        String getName() {
            return this.name;
        }

        Class getType() {
            return this.type;
        }

        void setType(Class type) {
            this.type = type;
        }

        String getHeading() {
            return this.heading;
        }

        boolean isEditable() {
            return this.editable;
        }

        void setEditable(boolean editable) {
            this.editable = editable;
        }
    }
}

