/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.table.StringTableKey;
import com.sap.sdt.util.value.table.StringTableKeyIF;
import com.sap.sdt.util.value.table.StringTableRowIF;
import com.sap.sdt.util.value.table.TableDescriptionIF;
import com.sap.sdt.util.value.table.TableKeyIF;
import com.sap.sdt.util.value.table.TableRowIF;
import com.sap.sdt.util.xml.XMLElementIF;

public class StringTableRow
extends StringTableKey
implements StringTableRowIF {
    private int index = 0;

    public StringTableRow(TableDescriptionIF table) {
        super(table, new String[table.getNumberColumns()]);
    }

    public StringTableRow(StringTableRowIF row) {
        this(row.getTableDescription(), new String[row.getTableDescription().getNumberColumns()]);
        for (int i = 0; i < this.columnValues.length; ++i) {
            this.columnValues[i] = row.getString(i);
        }
    }

    public StringTableRow(TableDescriptionIF table, String[] columnValues) {
        super(table, columnValues);
    }

    public StringTableRow(TableDescriptionIF table, XMLElementIF elem) throws ValueDeserializeException {
        this(table);
        super.deserialize(elem);
    }

    public StringTableKeyIF getStringKey() {
        return new StringTableKey(this.desc, this);
    }

    public final void add(String value) {
        super.set(this.index++, value);
    }

    public int compareTo(TableRowIF row) {
        return super.compareTo(row);
    }

    public TableKeyIF getKey() {
        return this.getStringKey();
    }

    public XMLElementIF serialize(XMLElementIF elem) throws ValueSerializeException {
        return super.serializeValue(elem, "StringValue");
    }

    protected String getType() {
        return "StringArray";
    }

    public Object clone() {
        StringTableRow clone = new StringTableRow(this);
        return clone;
    }
}

