/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.table.AbstractTable;
import com.sap.sdt.util.value.table.NoSuchRowException;
import com.sap.sdt.util.value.table.StringTableKey;
import com.sap.sdt.util.value.table.StringTableKeyIF;
import com.sap.sdt.util.value.table.StringTableRow;
import com.sap.sdt.util.value.table.StringTableRowIF;
import com.sap.sdt.util.value.table.TableDescriptionIF;
import com.sap.sdt.util.value.table.TableKeyIF;
import com.sap.sdt.util.value.table.TableRowFilterIF;
import com.sap.sdt.util.value.table.TableRowIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;

public class StringTable
extends AbstractTable {
    public StringTable(String[] columnNames, int numberKeyColumns) {
        super(columnNames, numberKeyColumns);
    }

    public StringTable(XMLElementIF elem) throws ValueDeserializeException {
        super(elem);
    }

    public final boolean contains(StringTableKeyIF key) {
        return super.contains(key);
    }

    public final boolean contains(StringTableRowIF row) {
        return super.contains(row);
    }

    public final boolean add(StringTableRowIF row) {
        return super.add(row);
    }

    public final boolean add(String[] columnValues) {
        return super.add(new StringTableRow((TableDescriptionIF)this, columnValues));
    }

    public final boolean change(StringTableRowIF row) {
        return super.change(row);
    }

    public TableRowIF getRow(TableKeyIF key) throws NoSuchRowException {
        Object entry = this.table.get(key);
        if (entry == null) {
            throw new NoSuchRowException(key);
        }
        StringTableRow row = new StringTableRow((StringTableRow)entry);
        return row;
    }

    public StringTableKeyIF getStringKey() {
        return new StringTableKey(this);
    }

    public StringTableKeyIF getStringKey(String[] columnValues) {
        return new StringTableKey((TableDescriptionIF)this, columnValues);
    }

    public StringTableRowIF getStringRow() {
        return new StringTableRow(this);
    }

    public StringTableRowIF getStringRow(String[] columnValues) {
        return new StringTableRow((TableDescriptionIF)this, columnValues);
    }

    public StringTableRowIF getStringRow(StringTableKeyIF key) throws NoSuchRowException {
        return (StringTableRowIF)this.getRow(key);
    }

    public final boolean remove(StringTableRowIF row) {
        return super.remove(row);
    }

    public final boolean remove(StringTableKeyIF key) {
        return super.remove(key);
    }

    public String getStringValue(StringTableKeyIF key, String columnName) throws NoSuchRowException {
        return this.getStringRow(key).getString(columnName);
    }

    public String getStringValue(StringTableKeyIF key, int columnIndex) throws NoSuchRowException {
        return this.getStringRow(key).getString(columnIndex);
    }

    public boolean setValue(StringTableKeyIF key, String columnName, String newValue) throws NoSuchRowException {
        return this.setValue(key, this.getColumnIndex(columnName), newValue);
    }

    public boolean setValue(StringTableKeyIF key, int columnIndex, String newValue) throws NoSuchRowException {
        return super.setValue(key, columnIndex, newValue);
    }

    public Object clone() {
        StringTable clone = new StringTable(this.columnNames, this.numberKeyColumns);
        StringRowIterator it = this.stringRowIterator();
        while (it.hasNext()) {
            StringTableRowIF row = it.next();
            clone.add(row);
        }
        return clone;
    }

    public Object clone(Object value) {
        return ((StringTable)value).clone();
    }

    public boolean equals(Object o) {
        if (o instanceof StringTable) {
            return super.equals((StringTable)o);
        }
        return false;
    }

    public String getType() {
        return "StringTable";
    }

    public StringRowIterator stringRowIterator() {
        return new StringRowIterator();
    }

    protected void deserializeRow(XMLElementIF subElem) throws ValueDeserializeException {
        this.add(new StringTableRow((TableDescriptionIF)this, subElem));
    }

    protected void serializeRows(XMLElementIF elem) throws ValueSerializeException {
        super.serializeRows(elem, "StringArray");
    }

    protected final boolean equals(StringTable table) {
        return super.equals(table);
    }

    public final StringTable select(TableRowFilterIF filter) {
        StringTable result = new StringTable(this.getColumnNames(), this.getNumberKeyColumns());
        return (StringTable)super.select(result, filter);
    }

    public static void main(String[] args) {
        StringTable st = new StringTable(new String[]{"Key", "Att", "ER"}, 1);
        StringTableRow row = new StringTableRow(st);
        row.set(0, "gaga");
        row.set(1, "huhu");
        st.add(row);
        row = new StringTableRow(st);
        row.set(0, "mama");
        row.set(1, "papa");
        st.add(row);
        row = new StringTableRow(st);
        row.set(0, "oma");
        row.set(1, "21");
        st.add(row);
        try {
            XMLElementIF elem = XMLAdmin.createXMLElement();
            st.serializeValue(elem);
            PrintWriter writer = new PrintWriter(System.out);
            elem.toXML(writer);
            ((Writer)writer).close();
            StringTable st2 = new StringTable(elem);
            XMLElementIF elem2 = XMLAdmin.createXMLElement();
            st2.serializeValue(elem2);
            writer = new PrintWriter(System.err);
            elem2.toXML(writer);
            ((Writer)writer).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class StringRowIterator {
        private Iterator it;

        public StringRowIterator() {
            this.it = StringTable.this.table.keySet().iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public StringTableRowIF next() {
            StringTableKey key = (StringTableKey)this.it.next();
            try {
                return StringTable.this.getStringRow(key);
            }
            catch (NoSuchRowException e) {
                throw new IllegalStateException();
            }
        }
    }
}

