/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.table.AbstractTable;
import com.sap.sdt.util.value.table.NoSuchRowException;
import com.sap.sdt.util.value.table.ObjectTableKey;
import com.sap.sdt.util.value.table.ObjectTableKeyIF;
import com.sap.sdt.util.value.table.ObjectTableRow;
import com.sap.sdt.util.value.table.ObjectTableRowIF;
import com.sap.sdt.util.value.table.TableDescriptionIF;
import com.sap.sdt.util.value.table.TableKeyIF;
import com.sap.sdt.util.value.table.TableRowFilterIF;
import com.sap.sdt.util.value.table.TableRowIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.File;
import java.util.Iterator;

public class ObjectTable
extends AbstractTable {
    public ObjectTable(String[] columnNames, Class[] columnTypes, int numberKeyColumns) {
        super(columnNames, columnTypes, numberKeyColumns);
    }

    public ObjectTable(XMLElementIF elem) throws ValueDeserializeException {
        super(elem);
    }

    public final boolean contains(ObjectTableKeyIF key) {
        return super.contains(key);
    }

    public final boolean contains(ObjectTableRowIF row) {
        return super.contains(row);
    }

    public final boolean add(ObjectTableRowIF row) {
        this.check(row);
        return super.add(row);
    }

    public final boolean add(Object[] columnValues) {
        return super.add(new ObjectTableRow((TableDescriptionIF)this, columnValues));
    }

    public final boolean change(ObjectTableRowIF row) {
        this.check(row);
        return super.change(row);
    }

    public TableRowIF getRow(TableKeyIF key) throws NoSuchRowException {
        Object entry = this.table.get(key);
        if (entry == null) {
            throw new NoSuchRowException(key);
        }
        ObjectTableRow row = new ObjectTableRow((ObjectTableRow)entry);
        return row;
    }

    public ObjectTableKeyIF getObjectKey() {
        return new ObjectTableKey(this);
    }

    public ObjectTableKeyIF getObjectKey(Object[] columnValues) {
        return new ObjectTableKey((TableDescriptionIF)this, columnValues);
    }

    public ObjectTableRowIF getObjectRow(ObjectTableKeyIF key) throws NoSuchRowException {
        this.check(key);
        return (ObjectTableRowIF)this.getRow(key);
    }

    public ObjectTableRowIF getObjectRow() {
        return new ObjectTableRow(this);
    }

    public ObjectTableRowIF getObjectRow(Object[] columnValues) {
        return new ObjectTableRow((TableDescriptionIF)this, columnValues);
    }

    public final boolean remove(ObjectTableRowIF row) {
        return super.remove(row);
    }

    public final boolean remove(ObjectTableKeyIF key) {
        this.check(key);
        return super.remove(key);
    }

    public String getStringValue(ObjectTableKeyIF key, String columnName) throws NoSuchRowException {
        return this.getObjectRow(key).getString(columnName);
    }

    public String getStringValue(ObjectTableKeyIF key, int columnIndex) throws NoSuchRowException {
        return this.getObjectRow(key).getString(columnIndex);
    }

    public Boolean getBooleanValue(ObjectTableKeyIF key, String columnName) throws NoSuchRowException {
        return this.getObjectRow(key).getBoolean(columnName);
    }

    public Boolean getBooleanValue(ObjectTableKeyIF key, int columnIndex) throws NoSuchRowException {
        return this.getObjectRow(key).getBoolean(columnIndex);
    }

    public Long getLongValue(ObjectTableKeyIF key, String columnName) throws NoSuchRowException {
        return this.getObjectRow(key).getLong(columnName);
    }

    public Long getLongValue(ObjectTableKeyIF key, int columnIndex) throws NoSuchRowException {
        return this.getObjectRow(key).getLong(columnIndex);
    }

    public File getFileValue(ObjectTableKeyIF key, String columnName) throws NoSuchRowException {
        return this.getObjectRow(key).getFile(columnName);
    }

    public File getFileValue(ObjectTableKeyIF key, int columnIndex) throws NoSuchRowException {
        return this.getObjectRow(key).getFile(columnIndex);
    }

    public boolean setValue(ObjectTableKeyIF key, String columnName, String newValue) throws NoSuchRowException {
        return this.setValue(key, this.getColumnIndex(columnName), newValue);
    }

    public boolean setValue(ObjectTableKeyIF key, String columnName, Boolean newValue) throws NoSuchRowException {
        return this.setValue(key, this.getColumnIndex(columnName), newValue);
    }

    public boolean setValue(ObjectTableKeyIF key, String columnName, Long newValue) throws NoSuchRowException {
        return this.setValue(key, this.getColumnIndex(columnName), newValue);
    }

    public boolean setValue(ObjectTableKeyIF key, String columnName, File newValue) throws NoSuchRowException {
        return this.setValue(key, this.getColumnIndex(columnName), newValue);
    }

    public boolean setValue(ObjectTableKeyIF key, int columnIndex, String newValue) throws NoSuchRowException {
        ObjectTableRowIF row = this.getObjectRow(key);
        if (row != null) {
            row.set(columnIndex, newValue);
            return this.change(row);
        }
        return false;
    }

    public boolean setValue(ObjectTableKeyIF key, int columnIndex, Boolean newValue) throws NoSuchRowException {
        return super.setValue(key, columnIndex, newValue);
    }

    public boolean setValue(ObjectTableKeyIF key, int columnIndex, Long newValue) throws NoSuchRowException {
        ObjectTableRowIF row = this.getObjectRow(key);
        if (row != null) {
            row.set(columnIndex, newValue);
            return this.change(row);
        }
        return false;
    }

    public boolean setValue(ObjectTableKeyIF key, int columnIndex, File newValue) throws NoSuchRowException {
        ObjectTableRowIF row = this.getObjectRow(key);
        if (row != null) {
            row.set(columnIndex, newValue);
            return this.change(row);
        }
        return false;
    }

    public Object clone() {
        ObjectTable clone = new ObjectTable(this.columnNames, this.columnTypes, this.numberKeyColumns);
        ObjectRowIterator it = this.objectRowIterator();
        while (it.hasNext()) {
            ObjectTableRowIF row = it.next();
            clone.add(row);
        }
        return clone;
    }

    public Object clone(Object value) {
        return ((ObjectTable)value).clone();
    }

    public boolean equals(Object o) {
        if (o instanceof ObjectTable) {
            return super.equals((ObjectTable)o);
        }
        return false;
    }

    public String getType() {
        return "ObjectTable";
    }

    public ObjectRowIterator objectRowIterator() {
        return new ObjectRowIterator();
    }

    protected void deserializeRow(XMLElementIF subElem) throws ValueDeserializeException {
        this.add(new ObjectTableRow((TableDescriptionIF)this, subElem));
    }

    protected void serializeRows(XMLElementIF elem) throws ValueSerializeException {
        super.serializeRows(elem, "ObjectArray");
    }

    protected final boolean equals(ObjectTable table) {
        return super.equals(table);
    }

    public final ObjectTable select(TableRowFilterIF filter) {
        ObjectTable result = new ObjectTable(this.getColumnNames(), this.getColumnTypes(), this.getNumberKeyColumns());
        return (ObjectTable)super.select(result, filter);
    }

    public class ObjectRowIterator {
        private Iterator it;

        public ObjectRowIterator() {
            this.it = ObjectTable.this.table.keySet().iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public ObjectTableRowIF next() {
            ObjectTableKey key = (ObjectTableKey)this.it.next();
            try {
                return ObjectTable.this.getObjectRow(key);
            }
            catch (NoSuchRowException e) {
                throw new IllegalStateException();
            }
        }
    }
}

