/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.value.AbstractValue;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.value.table.TableColumnTypeException;
import com.sap.sdt.util.value.table.TableColumnValueException;
import com.sap.sdt.util.value.table.TableColumnsIF;
import com.sap.sdt.util.value.table.TableDescriptionIF;
import com.sap.sdt.util.value.table.TableKeyException;
import com.sap.sdt.util.value.table.TableRowException;
import com.sap.sdt.util.value.table.TableRowIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.util.Iterator;

abstract class AbstractTableDescription
extends AbstractValue
implements TableDescriptionIF {
    protected String[] columnNames;
    protected Class[] columnTypes;
    protected int numberKeyColumns;
    static /* synthetic */ Class class$java$lang$String;

    AbstractTableDescription(String[] columnNames, int numberKeyColumns) {
        this(columnNames, AbstractTableDescription.getDefaultColumnTypes(columnNames.length), numberKeyColumns);
    }

    AbstractTableDescription(String[] columnNames, Class[] columnTypes, int numberKeyColumns) {
        this.columnNames = columnNames;
        this.columnTypes = columnTypes;
        this.numberKeyColumns = numberKeyColumns;
        int numberColumns = this.getNumberColumns();
        if (numberColumns < 1) {
            TableRowException e = new TableRowException(1, numberKeyColumns);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (numberKeyColumns < 1) {
            TableKeyException e = new TableKeyException(1, numberKeyColumns);
            throw new IllegalArgumentException(e.getMessage());
        }
        if (numberKeyColumns > numberColumns) {
            TableKeyException e = new TableKeyException(numberColumns, numberKeyColumns);
            throw new IllegalArgumentException(e.getMessage());
        }
        for (int i = 0; i < columnNames.length; ++i) {
            if (columnTypes[i] == null) {
                throw new NullPointerException();
            }
            String type = ValueFactory.getValueType(columnTypes[i]);
            if (!"Unknown".equals(type)) continue;
            TableColumnTypeException e = new TableColumnTypeException(columnNames[i], columnTypes[i]);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    AbstractTableDescription(XMLElementIF rootElem) throws ValueDeserializeException {
        this.deserialize(rootElem);
    }

    private static Class[] getDefaultColumnTypes(int numberColumns) {
        Class[] columnTypes = new Class[numberColumns];
        for (int i = 0; i < columnTypes.length; ++i) {
            columnTypes[i] = class$java$lang$String == null ? AbstractTableDescription.class$("java.lang.String") : class$java$lang$String;
        }
        return columnTypes;
    }

    public final int getColumnIndex(String columnName) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!columnName.equals(this.columnNames[i])) continue;
            return i;
        }
        return -1;
    }

    public final String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    public final String[] getColumnNames() {
        return this.columnNames;
    }

    public final boolean hasColumnName(String columnName) {
        for (int i = 0; i < this.columnNames.length; ++i) {
            if (!columnName.equals(this.columnNames[i])) continue;
            return true;
        }
        return false;
    }

    public final int getNumberColumns() {
        return this.columnNames.length;
    }

    public final int getNumberKeyColumns() {
        return this.numberKeyColumns;
    }

    public Class getColumnType(int columnIndex) {
        return this.columnTypes[columnIndex];
    }

    public Class[] getColumnTypes() {
        return this.columnTypes;
    }

    public final void check(Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.check(i, values[i]);
        }
    }

    public final void check(int index, Object value) {
        Class<?> valueType = value == null ? null : value.getClass();
        Class columnType = this.getColumnType(index);
        if (valueType != null && valueType != columnType) {
            String columnName = this.getColumnName(index);
            TableColumnValueException e = new TableColumnValueException(columnName, columnType, valueType);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void check(TableColumnsIF col) {
        if (col instanceof TableRowIF) {
            if (col.getNumberColumns() != this.getNumberColumns()) {
                TableRowException e = new TableRowException(this.getNumberColumns(), col.getNumberColumns());
                throw new IllegalArgumentException(e.getMessage());
            }
        } else if (col.getNumberColumns() != this.getNumberKeyColumns()) {
            TableKeyException e = new TableKeyException(this.getNumberKeyColumns(), col.getNumberColumns());
            throw new IllegalArgumentException(e.getMessage());
        }
        this.check(col.getColumnValues());
    }

    protected final boolean equals(TableDescriptionIF table) {
        int i;
        if (this.getNumberColumns() != table.getNumberColumns()) {
            return false;
        }
        if (this.getNumberKeyColumns() != table.getNumberKeyColumns()) {
            return false;
        }
        for (i = 0; i < this.getNumberColumns(); ++i) {
            if (this.getColumnName(i).equals(table.getColumnName(i))) continue;
            return false;
        }
        for (i = 0; i < this.getNumberColumns(); ++i) {
            if (this.getColumnType(i).equals(table.getColumnType(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer out = new StringBuffer("\n");
        String delim = "; ";
        for (int i = 0; i < this.columnNames.length; ++i) {
            out.append(this.columnNames[i] + ':');
            out.append(this.columnTypes[i] + "; ");
        }
        out.append("\n");
        return out.toString();
    }

    private void deserialize(XMLElementIF rootElem) throws ValueDeserializeException {
        try {
            int numberColumns = 0;
            if (!rootElem.hasSubElements()) {
                throw new WrongSyntaxException("<END OF EXPRESSION>", "TableDefinition");
            }
            Iterator it = rootElem.getSubElements();
            while (it.hasNext()) {
                WrongSyntaxException e;
                XMLElementIF subElem = (XMLElementIF)it.next();
                if (!subElem.getName().equals("TableDefinition")) continue;
                try {
                    numberColumns = Integer.parseInt(subElem.getAttrString("NumberColumns"));
                    this.columnNames = new String[numberColumns];
                    this.columnTypes = new Class[numberColumns];
                }
                catch (XMLException xmlE) {
                    WrongSyntaxException e2 = new WrongSyntaxException("<END OF EXPRESSION>", "NumberColumns");
                    throw e2;
                }
                try {
                    this.numberKeyColumns = Integer.parseInt(subElem.getAttrString("NumberKeyColumns"));
                }
                catch (XMLException xmlE) {
                    WrongSyntaxException e3 = new WrongSyntaxException("<END OF EXPRESSION>", "NumberKeyColumns");
                    throw e3;
                }
                Iterator colIt = subElem.getSubElements();
                int columnIndex = 0;
                while (colIt.hasNext()) {
                    XMLElementIF colElem = (XMLElementIF)colIt.next();
                    if (!colElem.getName().equals("ColumnName")) continue;
                    this.columnNames[columnIndex] = colElem.getContent();
                    try {
                        Class clazz;
                        this.columnTypes[columnIndex] = clazz = ValueFactory.getValueClass(colElem.getAttrString("type"));
                    }
                    catch (XMLException xmlE) {
                        this.columnTypes[columnIndex] = class$java$lang$String == null ? AbstractTableDescription.class$("java.lang.String") : class$java$lang$String;
                    }
                    ++columnIndex;
                }
                if (columnIndex < numberColumns) {
                    e = new WrongSyntaxException("<END OF EXPRESSION>", "ColumnName");
                    throw e;
                }
                if (columnIndex <= numberColumns) continue;
                e = new WrongSyntaxException("ColumnName", "<END OF EXPRESSION>");
                throw e;
            }
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(this.getType(), e);
        }
    }

    protected XMLElementIF serialize(XMLElementIF elem) {
        int cols = this.getNumberColumns();
        int keys = this.getNumberKeyColumns();
        XMLElementIF defElem = XMLAdmin.createXMLElement();
        defElem.setName("TableDefinition");
        defElem.setAttr("NumberColumns", Integer.toString(cols));
        defElem.setAttr("NumberKeyColumns", Integer.toString(keys));
        String[] columns = this.getColumnNames();
        for (int i = 0; i < columns.length; ++i) {
            XMLElementIF subElem = XMLAdmin.createXMLElement();
            subElem.setName("ColumnName");
            subElem.setContent(columns[i]);
            String type = ValueFactory.getValueType(this.columnTypes[i]);
            subElem.setAttr("type", type);
            defElem.add(subElem);
        }
        elem.add(defElem);
        return elem;
    }
}

