/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.table.TableCellValue;
import com.sap.sdt.util.value.table.TableColumnsIF;
import com.sap.sdt.util.value.table.TableDescriptionIF;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Iterator;

abstract class AbstractTableColumns
implements TableColumnsIF {
    protected TableDescriptionIF desc;
    protected Object[] columnValues;

    AbstractTableColumns(TableDescriptionIF desc, Object[] columnValues) {
        this.desc = desc;
        this.columnValues = columnValues;
        desc.check(this);
    }

    public final int getNumberColumns() {
        return this.columnValues.length;
    }

    public final Object[] getColumnValues() {
        return this.columnValues;
    }

    public final Object get(int columnIndex) {
        return this.columnValues[columnIndex];
    }

    public void set(int columnIndex, Object value) throws IllegalArgumentException {
        this.desc.check(columnIndex, value);
        this.columnValues[columnIndex] = value;
    }

    protected int compareTo(TableColumnsIF col) {
        int minSize = Math.min(this.getNumberColumns(), col.getNumberColumns());
        for (int i = 0; i < minSize; ++i) {
            TableCellValue otherValue;
            TableCellValue thisValue = new TableCellValue(this.get(i));
            if (thisValue.equals(otherValue = new TableCellValue(col.get(i)))) continue;
            return thisValue.compareTo(otherValue);
        }
        return 0;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[");
        for (int i = 0; i < this.getNumberColumns(); ++i) {
            b.append(this.get(i));
            if (i >= this.getNumberColumns() - 1) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    public final TableDescriptionIF getTableDescription() {
        return this.desc;
    }

    public final Object get(String columnName) {
        return this.get(this.desc.getColumnIndex(columnName));
    }

    protected void set(String columnName, Object value) throws IllegalArgumentException {
        this.set(this.desc.getColumnIndex(columnName), value);
    }

    public final void set(int columnIndex, String value) {
        this.columnValues[columnIndex] = value;
    }

    public final void set(String columnName, String value) {
        this.set(this.desc.getColumnIndex(columnName), value);
    }

    public final String getString(int columnIndex) {
        return (String)this.get(columnIndex);
    }

    public final String getString(String columnName) {
        return (String)this.get(columnName);
    }

    protected abstract String getType();

    public final void deserialize(XMLElementIF rootElem) throws ValueDeserializeException {
        try {
            int i = 0;
            Iterator it = rootElem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                String type = ValueFactory.getValueType(this.desc.getColumnType(i));
                Object value = ValueFactory.deserializeValue(type, subElem);
                this.set(i, value);
                ++i;
            }
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(this.getType(), e);
        }
    }

    protected XMLElementIF serializeValue(XMLElementIF elem) throws ValueSerializeException {
        return this.serializeValue(elem, "ObjectValue");
    }

    protected final XMLElementIF serializeValue(XMLElementIF elem, String elemName) throws ValueSerializeException {
        try {
            for (int i = 0; i < this.getNumberColumns(); ++i) {
                XMLElementIF subElem = XMLAdmin.createXMLElement();
                subElem.setName(elemName);
                ValueFactory.serializeValue(this.get(i), subElem);
                elem.add(subElem);
            }
            return elem;
        }
        catch (DiagException e) {
            throw new ValueSerializeException(this.getType(), e);
        }
    }
}

