/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value.table;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.parse.MacroProviderIF;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.table.AbstractTableDescription;
import com.sap.sdt.util.value.table.DefaultTableRowFilter;
import com.sap.sdt.util.value.table.NoSuchRowException;
import com.sap.sdt.util.value.table.TableIF;
import com.sap.sdt.util.value.table.TableKeyComparator;
import com.sap.sdt.util.value.table.TableKeyIF;
import com.sap.sdt.util.value.table.TableRowFilterIF;
import com.sap.sdt.util.value.table.TableRowIF;
import com.sap.sdt.util.value.table.TableRowIteratorIF;
import com.sap.sdt.util.value.table.TableRowMacroProvider;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

abstract class AbstractTable
extends AbstractTableDescription
implements TableIF {
    protected TreeMap table;
    private Comparator keyComparator = new TableKeyComparator();

    AbstractTable(String[] columnNames, int numberKeyColumns) {
        super(columnNames, numberKeyColumns);
        this.init();
    }

    AbstractTable(String[] columnNames, Class[] columnTypes, int numberKeyColumns) {
        super(columnNames, columnTypes, numberKeyColumns);
        this.init();
    }

    AbstractTable(XMLElementIF rootElem) throws ValueDeserializeException {
        super(rootElem);
        this.init();
        try {
            Iterator it = rootElem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                if (!subElem.getName().equals("ObjectArray") && !subElem.getName().equals("StringArray")) continue;
                this.deserializeRow(subElem);
            }
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(this.getType(), e);
        }
    }

    private void init() {
        this.keyComparator = new TableKeyComparator();
        this.table = new TreeMap(this.keyComparator);
    }

    public final int size() {
        return this.table.size();
    }

    public final void clear() {
        this.table.clear();
    }

    public final boolean isEmpty() {
        return this.table.isEmpty();
    }

    protected final boolean contains(TableKeyIF key) {
        return this.table.containsKey(key);
    }

    protected final boolean contains(TableRowIF row) {
        TableKeyIF key = row.getKey();
        if (this.contains(key)) {
            try {
                return row.compareTo(this.getRow(key)) == 0;
            }
            catch (NoSuchRowException e) {
                return false;
            }
        }
        return false;
    }

    protected final boolean add(TableRowIF row) {
        TableKeyIF key = row.getKey();
        if (this.contains(key)) {
            return false;
        }
        this.table.put(key, row.clone());
        return true;
    }

    protected final boolean change(TableRowIF row) {
        TableKeyIF key = row.getKey();
        if (this.contains(key)) {
            this.table.put(key, row.clone());
            return true;
        }
        return false;
    }

    protected abstract TableRowIF getRow(TableKeyIF var1) throws NoSuchRowException;

    public final Object getValue(TableKeyIF key, String columnName) throws NoSuchRowException {
        return this.getRow(key).get(columnName);
    }

    public final Object getValue(TableKeyIF key, int columnIndex) throws NoSuchRowException {
        return this.getRow(key).get(columnIndex);
    }

    public final boolean setValue(TableKeyIF key, int columnIndex, Object newValue) throws NoSuchRowException {
        TableRowIF row = this.getRow(key);
        if (row != null) {
            row.set(columnIndex, newValue);
            return this.change(row);
        }
        return false;
    }

    protected final boolean remove(TableRowIF row) {
        return this.remove(row.getKey());
    }

    protected final boolean remove(TableKeyIF key) {
        if (this.contains(key)) {
            this.table.remove(key);
            return true;
        }
        return false;
    }

    public abstract Object clone();

    public abstract Object clone(Object var1);

    public abstract boolean equals(Object var1);

    protected final boolean equals(AbstractTable table) {
        if (!super.equals(table)) {
            return false;
        }
        if (this.size() != table.size()) {
            return false;
        }
        TableRowIteratorIF it = this.rowIterator();
        while (it.hasNext()) {
            TableRowIF row = it.next();
            if (table.contains(row)) continue;
            return false;
        }
        return true;
    }

    protected abstract void deserializeRow(XMLElementIF var1) throws ValueDeserializeException;

    protected abstract void serializeRows(XMLElementIF var1) throws ValueSerializeException;

    protected final void serializeRows(XMLElementIF elem, String elemName) throws ValueSerializeException {
        TableRowIteratorIF it = this.rowIterator();
        while (it.hasNext()) {
            TableRowIF row = it.next();
            XMLElementIF subElem = XMLAdmin.createXMLElement();
            subElem.setName(elemName);
            row.serialize(subElem);
            elem.add(subElem);
        }
    }

    public XMLElementIF serializeValue(XMLElementIF elem) throws ValueSerializeException {
        elem = super.serialize(elem);
        this.serializeRows(elem);
        return elem;
    }

    public final TableRowIteratorIF rowIterator() {
        return new RowIterator();
    }

    public final MacroProviderIF.MacroIteratorIF rowMacroIterator() {
        return new RowMacroIterator();
    }

    public final String toString() {
        StringBuffer out = new StringBuffer(super.toString());
        String delim = "; ";
        TableRowIteratorIF it = this.rowIterator();
        while (it.hasNext()) {
            TableRowIF row = it.next();
            for (int i = 0; i < row.getNumberColumns(); ++i) {
                out.append(row.get(i) + "; ");
            }
            out.append("\n");
        }
        return out.toString();
    }

    public final TableRowFilterIF getDefaultRowFilter(String columnName, Object value) {
        return new DefaultTableRowFilter(columnName, value);
    }

    protected final AbstractTable select(AbstractTable result, TableRowFilterIF filter) {
        TableRowIteratorIF it = this.rowIterator();
        while (it.hasNext()) {
            TableRowIF row = it.next();
            if (!filter.accept(this, row)) continue;
            result.add(row);
        }
        return result;
    }

    public final class RowMacroIterator
    implements MacroProviderIF.MacroIteratorIF {
        private TableRowIteratorIF it;

        public RowMacroIterator() {
            this.it = AbstractTable.this.rowIterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public MacroProviderIF next() {
            return new TableRowMacroProvider(this.it.next());
        }
    }

    class RowIterator
    implements TableRowIteratorIF {
        private Iterator it;

        RowIterator() {
            this.it = AbstractTable.this.table.keySet().iterator();
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public TableRowIF next() {
            TableKeyIF key = (TableKeyIF)this.it.next();
            try {
                return AbstractTable.this.getRow(key);
            }
            catch (NoSuchRowException e) {
                throw new IllegalStateException();
            }
        }
    }
}

