/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.security.DefaultEncryptionFactory;
import com.sap.sdt.util.security.EncryptionFactoryIF;
import com.sap.sdt.util.serial.SerialAdmin;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.value.EnumerationValue;
import com.sap.sdt.util.value.Password;
import com.sap.sdt.util.value.StringArray;
import com.sap.sdt.util.value.StringPair;
import com.sap.sdt.util.value.UnknownTypeException;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueIF;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.value.table.ObjectTable;
import com.sap.sdt.util.value.table.StringTable;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.io.File;

public class ValueFactory {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/ValueFactory.java#2 $";
    private static EncryptionFactoryIF encryptionFactory;

    public static String getValueType(Object value) {
        if (value == null) {
            return "Unknown";
        }
        return ValueFactory.getValueType(value.getClass());
    }

    public static String getValueType(Class valueClass) {
        if (valueClass == String.class) {
            return "String";
        }
        if (valueClass == Long.class) {
            return "Long";
        }
        if (valueClass == Boolean.class) {
            return "Boolean";
        }
        if (valueClass == File.class) {
            return "File";
        }
        if (valueClass == StringPair.class) {
            return "StringPair";
        }
        if (valueClass == StringArray.class) {
            return "StringArray";
        }
        if (valueClass == StringTable.class) {
            return "StringTable";
        }
        if (valueClass == ObjectTable.class) {
            return "ObjectTable";
        }
        if (valueClass == Password.class) {
            return "Password";
        }
        if (valueClass == DiagException.class) {
            return "DiagException";
        }
        if (valueClass == EnumerationValue.class) {
            return "Enumeration";
        }
        return "Unknown";
    }

    public static Class getValueClass(String type) throws UnknownTypeException {
        if (type.equals("String")) {
            return String.class;
        }
        if (type.equals("Boolean")) {
            return Boolean.class;
        }
        if (type.equals("Long")) {
            return Long.class;
        }
        if (type.equals("File")) {
            return File.class;
        }
        if (type.equals("Password")) {
            return Password.class;
        }
        if (type.equals("StringPair")) {
            return StringPair.class;
        }
        if (type.equals("StringArray")) {
            return StringArray.class;
        }
        if (type.equals("StringTable")) {
            return StringTable.class;
        }
        if (type.equals("ObjectTable")) {
            return ObjectTable.class;
        }
        if (type.equals("DiagException")) {
            return DiagException.class;
        }
        if (type.equals("Enumeration")) {
            return EnumerationValue.class;
        }
        throw new UnknownTypeException(type);
    }

    public static XMLElementIF serializeValue(Object value, XMLElementIF elem) throws UnknownTypeException, ValueSerializeException {
        if (value == null) {
            elem.setAttr("null", new Boolean(true).toString());
            return elem;
        }
        if (value instanceof String) {
            elem.setContent((String)value);
            return elem;
        }
        if (value instanceof Long) {
            elem.setContent(((Long)value).toString());
            return elem;
        }
        if (value instanceof Boolean) {
            elem.setContent(((Boolean)value).toString());
            return elem;
        }
        if (value instanceof File) {
            elem.setContent(((File)value).getAbsolutePath());
            return elem;
        }
        if (value instanceof DiagException) {
            try {
                XMLElementIF subElem = SerialAdmin.serialize(value);
                elem.add(subElem);
                return elem;
            }
            catch (SerialException e) {
                throw new ValueSerializeException("DiagException", e);
            }
        }
        if (value instanceof ValueIF) {
            return ((ValueIF)value).serializeValue(elem);
        }
        throw new UnknownTypeException(ValueFactory.getValueType(value));
    }

    public static Object deserializeValue(String type, XMLElementIF elem) throws UnknownTypeException, ValueDeserializeException {
        try {
            if (ValueFactory.isSerializedNullValue(elem)) {
                return null;
            }
            String content = elem.getContent();
            if (type.equals("String")) {
                return content == null ? "" : content;
            }
            if (type.equals("Boolean")) {
                return content == null ? Boolean.FALSE : Boolean.valueOf(content);
            }
            if (type.equals("Long")) {
                try {
                    return content == null ? new Long(0L) : Long.valueOf(content.trim());
                }
                catch (NumberFormatException numEx) {
                    throw new WrongSyntaxException(numEx.getMessage());
                }
            }
            if (type.equals("File")) {
                return content == null ? new File("") : new File(content);
            }
            if (type.equals("Password")) {
                return new Password(elem);
            }
            if (type.equals("StringPair")) {
                return new StringPair(elem);
            }
            if (type.equals("StringArray")) {
                return new StringArray(elem);
            }
            if (type.equals("Enumeration")) {
                return new EnumerationValue(elem);
            }
            if (type.equals("StringTable")) {
                return new StringTable(elem);
            }
            if (type.equals("ObjectTable")) {
                return new ObjectTable(elem);
            }
            if (type.equals("DiagException")) {
                try {
                    XMLElementIF subElem = (XMLElementIF)elem.getSubElements().next();
                    return SerialAdmin.deserialize(subElem);
                }
                catch (SerialException e) {
                    throw new ValueDeserializeException("DiagException", e);
                }
            }
            throw new UnknownTypeException(type);
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(type, e);
        }
    }

    public static final boolean isSerializedNullValue(XMLElementIF elem) {
        try {
            return Boolean.valueOf(elem.getAttrString("null"));
        }
        catch (XMLException e) {
            return false;
        }
    }

    public static Object cloneValue(Object value) throws CloneNotSupportedException {
        if (value == null) {
            throw new NullPointerException();
        }
        if (value instanceof String) {
            return new String((String)value);
        }
        if (value instanceof Long) {
            return new Long((Long)value);
        }
        if (value instanceof Boolean) {
            return new Boolean((Boolean)value);
        }
        if (value instanceof File) {
            return new File(((File)value).getAbsolutePath());
        }
        if (value instanceof DiagException) {
            return ((DiagException)value).clone();
        }
        if (value instanceof ValueIF) {
            return ((ValueIF)value).clone(value);
        }
        throw new CloneNotSupportedException(value.getClass().getName());
    }

    public static EncryptionFactoryIF getEncryptionFactory() {
        if (encryptionFactory == null) {
            encryptionFactory = new DefaultEncryptionFactory();
        }
        return encryptionFactory;
    }

    public static void setEncryptionFactory(EncryptionFactoryIF factory) {
        encryptionFactory = factory;
    }
}

