/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.value.AbstractValue;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Iterator;

public class StringPair
extends AbstractValue {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/StringPair.java#2 $";
    private String left = null;
    private String right = null;

    public StringPair(String left, String right) {
        this.left = left;
        this.right = right;
    }

    public StringPair(StringPair pair) {
        this.left = pair.left;
        this.right = pair.right;
    }

    public StringPair(XMLElementIF elem) throws ValueDeserializeException {
        this.deserializeValue(elem);
    }

    public String getType() {
        return "StringPair";
    }

    public String getLeft() {
        return this.left;
    }

    public String getRight() {
        return this.right;
    }

    public String toString() {
        return "[" + this.left + "," + this.right + "]";
    }

    public Object clone(Object value) {
        return new StringPair((StringPair)value);
    }

    public boolean equals(Object o) {
        if (o instanceof StringPair) {
            return this.equals((StringPair)o);
        }
        return false;
    }

    public boolean equals(StringPair pair) {
        return this.left.equals(pair.left) && this.right.equals(pair.right);
    }

    public void deserializeValue(XMLElementIF rootElem) throws ValueDeserializeException {
        try {
            this.left = null;
            this.right = null;
            boolean leftToBeParsed = true;
            boolean rightToBeParsed = true;
            if (!rootElem.hasSubElements()) {
                throw new WrongSyntaxException("<END OF EXPRESSION>", "StringValue");
            }
            Iterator it = rootElem.getSubElements();
            while (it.hasNext()) {
                String content;
                XMLElementIF subElem = (XMLElementIF)it.next();
                if (!subElem.getName().equals("StringValue")) continue;
                if (leftToBeParsed) {
                    leftToBeParsed = false;
                    if (ValueFactory.isSerializedNullValue(subElem)) {
                        this.left = null;
                        continue;
                    }
                    content = subElem.getContent();
                    this.left = content == null ? "" : content;
                    continue;
                }
                if (rightToBeParsed) {
                    rightToBeParsed = false;
                    if (ValueFactory.isSerializedNullValue(subElem)) {
                        this.right = null;
                        continue;
                    }
                    content = subElem.getContent();
                    this.right = content == null ? "" : content;
                    continue;
                }
                throw new WrongSyntaxException(subElem.getName(), "<END OF EXPRESSION>");
            }
            if (leftToBeParsed || rightToBeParsed) {
                throw new WrongSyntaxException("<END OF EXPRESSION>", "StringValue");
            }
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(this.getType(), e);
        }
    }

    public XMLElementIF serializeValue(XMLElementIF elem) {
        XMLElementIF leftSubElem = XMLAdmin.createXMLElement();
        leftSubElem.setName("StringValue");
        if (!this.serializeNullValue(leftSubElem, this.getLeft())) {
            leftSubElem.setContent(this.getLeft());
        }
        elem.add(leftSubElem);
        XMLElementIF rightSubElem = XMLAdmin.createXMLElement();
        rightSubElem.setName("StringValue");
        if (!this.serializeNullValue(rightSubElem, this.getRight())) {
            rightSubElem.setContent(this.getRight());
        }
        elem.add(rightSubElem);
        return elem;
    }
}

