/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value;

import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.value.AbstractValue;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class StringArray
extends AbstractValue {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/StringArray.java#2 $";
    private ArrayList varlist;

    public StringArray() {
        this.varlist = new ArrayList();
    }

    public StringArray(Collection c) {
        this.varlist = new ArrayList(c);
    }

    public StringArray(int initialCapacity) {
        this.varlist = new ArrayList(initialCapacity);
    }

    public StringArray(String string) {
        this.varlist = new ArrayList(1);
        this.add(string);
    }

    public StringArray(String[] stringArray) {
        this.varlist = new ArrayList<String>(Arrays.asList(stringArray));
    }

    public StringArray(StringArray stringArray) {
        this.varlist = new ArrayList(stringArray.varlist);
    }

    public StringArray(XMLElementIF elem) throws WrongSyntaxException {
        this.deserializeValue(elem);
    }

    public void deserializeValue(XMLElementIF rootElem) {
        this.varlist = new ArrayList();
        if (rootElem.hasSubElements()) {
            Iterator it = rootElem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                if (!subElem.getName().equals("StringValue")) continue;
                if (ValueFactory.isSerializedNullValue(subElem)) {
                    this.varlist.add(null);
                    continue;
                }
                String content = subElem.getContent();
                this.varlist.add(content == null ? "" : content);
            }
        }
    }

    public XMLElementIF serializeValue(XMLElementIF elem) {
        for (int i = 0; i < this.size(); ++i) {
            XMLElementIF subElem = XMLAdmin.createXMLElement();
            subElem.setName("StringValue");
            if (!this.serializeNullValue(subElem, this.get(i))) {
                subElem.setContent(this.get(i));
            }
            elem.add(subElem);
        }
        return elem;
    }

    public String getType() {
        return "StringArray";
    }

    public int size() {
        return this.varlist.size();
    }

    public void trimToSize() {
        this.varlist.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
        this.varlist.ensureCapacity(minCapacity);
    }

    public boolean isEmpty() {
        return this.varlist.isEmpty();
    }

    public int compareTo(StringArray array) {
        int minSize = Math.min(this.size(), array.size());
        for (int i = 0; i < minSize; ++i) {
            if (this.get(i).equals(array.get(i))) continue;
            return this.get(i).compareTo(array.get(i));
        }
        return 0;
    }

    public boolean contains(String s) {
        return this.varlist.contains(s);
    }

    public boolean equals(Object o) {
        if (o instanceof StringArray) {
            return this.equals((StringArray)o);
        }
        return false;
    }

    public boolean equals(StringArray array) {
        if (this.size() == array.size()) {
            return 0 == this.compareTo(array);
        }
        return false;
    }

    public Iterator iterator() {
        return this.varlist.iterator();
    }

    public String[] toArray() {
        String[] result = new String[this.size()];
        return this.varlist.toArray(result);
    }

    public boolean add(String s) {
        return this.varlist.add(s);
    }

    public boolean add(String[] sArr) {
        if (sArr == null) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < sArr.length; ++i) {
            changed = this.varlist.add(sArr[i]);
        }
        return changed;
    }

    public boolean add(StringArray sArr) {
        if (sArr == null) {
            return false;
        }
        boolean changed = false;
        Iterator it = sArr.iterator();
        while (it.hasNext()) {
            changed = this.varlist.add((String)it.next());
        }
        return changed;
    }

    public boolean remove(String s) {
        return this.varlist.remove(s);
    }

    public boolean containsAll(StringArray a) {
        return this.varlist.containsAll(a.varlist);
    }

    public boolean addAll(StringArray a) {
        return this.varlist.addAll(a.varlist);
    }

    public boolean addAll(int index, StringArray a) {
        return this.varlist.addAll(index, a.varlist);
    }

    public boolean removeAll(StringArray a) {
        return this.varlist.removeAll(a.varlist);
    }

    public boolean retainAll(StringArray a) {
        return this.varlist.retainAll(a.varlist);
    }

    public void clear() {
        this.varlist.clear();
    }

    public String get(int index) {
        return (String)this.varlist.get(index);
    }

    public String set(int index, String s) {
        return this.varlist.set(index, s);
    }

    public void add(int index, String s) {
        this.varlist.add(index, s);
    }

    public String remove(int index) {
        return (String)this.varlist.remove(index);
    }

    public int indexOf(String s) {
        return this.varlist.indexOf(s);
    }

    public int lastIndexOf(String s) {
        return this.varlist.lastIndexOf(s);
    }

    public ListIterator listIterator() {
        return this.varlist.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.varlist.listIterator(index);
    }

    public List subList(int fromIndex, int toIndex) {
        return this.varlist.subList(fromIndex, toIndex);
    }

    public Object clone() {
        return new StringArray(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("[");
        for (int i = 0; i < this.size(); ++i) {
            b.append(this.get(i));
            if (i >= this.size() - 1) continue;
            b.append(",");
        }
        b.append("]");
        return b.toString();
    }

    public Object clone(Object value) {
        return new StringArray((StringArray)value);
    }
}

