/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.value.AbstractValue;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.xml.XMLElementIF;

public class Password
extends AbstractValue {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/Password.java#2 $";
    private String value;

    public Password(String value) {
        this.value = value;
    }

    public Password(Password password) {
        this.value = password.value;
    }

    public Password(XMLElementIF elem) throws ValueDeserializeException {
        this.deserializeValue(elem);
    }

    public void deserializeValue(XMLElementIF rootElem) throws ValueDeserializeException {
        try {
            String content = rootElem.getContent();
            this.value = content == null ? "" : this.decrypt(content);
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(this.getType(), e);
        }
    }

    public XMLElementIF serializeValue(XMLElementIF elem) throws ValueSerializeException {
        try {
            elem.setContent(this.encrypt(this.value));
            return elem;
        }
        catch (DiagException e) {
            throw new ValueSerializeException(this.getType(), e);
        }
    }

    public String getType() {
        return "Password";
    }

    public String toString() {
        return this.value;
    }

    public Object clone(Object value) {
        return new Password((Password)value);
    }

    public boolean equals(Object other) {
        if (other instanceof Password) {
            return this.value.equals(((Password)other).value);
        }
        return super.equals(other);
    }
}

