/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.WrongSyntaxException;
import com.sap.sdt.util.value.AbstractValue;
import com.sap.sdt.util.value.StringArray;
import com.sap.sdt.util.value.ValueDeserializeException;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.util.Iterator;

public class EnumerationVariable
extends AbstractValue {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/EnumerationVariable.java#2 $";
    private StringArray varList = null;
    private String currentValue = null;

    public EnumerationVariable(StringArray varList, String currentValue) {
        this.varList = varList;
        this.currentValue = currentValue;
    }

    public EnumerationVariable(EnumerationVariable enumerationVariable) {
        this.varList = enumerationVariable.varList;
        this.currentValue = enumerationVariable.currentValue;
    }

    public EnumerationVariable(XMLElementIF elem) throws ValueDeserializeException {
        this.deserializeValue(elem);
    }

    public String getType() {
        return "Enumeration";
    }

    public StringArray getVarList() {
        return this.varList;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public String toString() {
        return "[" + this.varList.toString() + "," + this.currentValue + "]";
    }

    public Object clone(Object value) {
        return new EnumerationVariable((EnumerationVariable)value);
    }

    public boolean equals(Object o) {
        if (o instanceof EnumerationVariable) {
            return this.equals((EnumerationVariable)o);
        }
        return false;
    }

    public boolean equals(EnumerationVariable pair) {
        return this.varList.equals(pair.varList) && this.currentValue.equals(pair.currentValue);
    }

    public void deserializeValue(XMLElementIF rootElem) throws ValueDeserializeException {
        try {
            this.varList = new StringArray();
            this.currentValue = "";
            if (!rootElem.hasSubElements()) {
                throw new WrongSyntaxException("<END OF EXPRESSION>", "StringValue");
            }
            Iterator it = rootElem.getSubElements();
            while (it.hasNext()) {
                XMLElementIF subElem = (XMLElementIF)it.next();
                if (subElem.getName().equals("StringArray")) {
                    Iterator arrayIT = subElem.getSubElements();
                    while (arrayIT.hasNext()) {
                        XMLElementIF arraySubElem = (XMLElementIF)arrayIT.next();
                        if (!arraySubElem.getName().equals("StringValue")) continue;
                        if (ValueFactory.isSerializedNullValue(arraySubElem)) {
                            this.varList.add("");
                            continue;
                        }
                        String content = arraySubElem.getContent();
                        this.varList.add(content == null ? "" : content);
                    }
                    continue;
                }
                if (subElem.getName().equals("StringValue")) {
                    if (ValueFactory.isSerializedNullValue(subElem)) {
                        this.currentValue = null;
                        continue;
                    }
                    String content = subElem.getContent();
                    this.currentValue = content == null ? "" : content;
                    continue;
                }
                throw new WrongSyntaxException(subElem.getName(), "<END OF EXPRESSION>");
            }
        }
        catch (DiagException e) {
            throw new ValueDeserializeException(this.getType(), e);
        }
    }

    public XMLElementIF serializeValue(XMLElementIF elem) {
        XMLElementIF varListSubElem = XMLAdmin.createXMLElement();
        varListSubElem.setName("StringArray");
        if (!this.serializeNullValue(varListSubElem, this.getVarList())) {
            for (int i = 0; i < this.varList.size(); ++i) {
                XMLElementIF subElem = XMLAdmin.createXMLElement();
                subElem.setName("StringValue");
                if (!this.serializeNullValue(subElem, this.varList.get(i))) {
                    subElem.setContent(this.varList.get(i));
                }
                varListSubElem.add(subElem);
            }
        }
        elem.add(varListSubElem);
        XMLElementIF currentValueSubElem = XMLAdmin.createXMLElement();
        currentValueSubElem.setName("StringValue");
        if (!this.serializeNullValue(currentValueSubElem, this.getCurrentValue())) {
            currentValueSubElem.setContent(this.getCurrentValue());
        }
        elem.add(currentValueSubElem);
        return elem;
    }
}

