/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.value;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.value.DecryptException;
import com.sap.sdt.util.value.EncryptException;
import com.sap.sdt.util.value.ValueConstants;
import com.sap.sdt.util.value.ValueDecryptException;
import com.sap.sdt.util.value.ValueEncryptException;
import com.sap.sdt.util.value.ValueFactory;
import com.sap.sdt.util.value.ValueIF;
import com.sap.sdt.util.value.ValueSerializeException;
import com.sap.sdt.util.xml.XMLElementIF;

public abstract class AbstractValue
implements ValueIF,
ValueConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/value/AbstractValue.java#2 $";

    public abstract String getType();

    public abstract XMLElementIF serializeValue(XMLElementIF var1) throws ValueSerializeException;

    protected final boolean serializeNullValue(XMLElementIF rootElem, Object value) {
        if (value == null) {
            rootElem.setAttr("null", new Boolean(true).toString());
            return true;
        }
        return false;
    }

    protected final String encrypt(String value) throws ValueEncryptException {
        try {
            try {
                return ValueFactory.getEncryptionFactory().encrypt(value);
            }
            catch (Exception e) {
                throw new EncryptException(e);
            }
        }
        catch (DiagException diagEx) {
            throw new ValueEncryptException(diagEx);
        }
    }

    protected final String decrypt(String value) throws ValueDecryptException {
        try {
            try {
                return ValueFactory.getEncryptionFactory().decrypt(value);
            }
            catch (Exception e) {
                throw new DecryptException(e);
            }
        }
        catch (DiagException diagEx) {
            throw new ValueDecryptException(diagEx);
        }
    }

    public abstract Object clone(Object var1);
}

