/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.validate;

import com.sap.sdt.trace.LoggerIF;
import com.sap.sdt.trace.LoggingEnabledIF;
import com.sap.sdt.trace.NullLogger;
import com.sap.sdt.util.validate.MsgIdConstants;
import com.sap.sdt.util.validate.ValidateableIF;
import com.sap.sdt.util.validate.ValidationException;
import com.sap.sdt.util.validate.ValidationFailureException;
import com.sap.sdt.util.validate.ValidationTraceIF;
import com.sap.sdt.util.validate.ValidatorIF;
import java.util.Collection;
import java.util.Iterator;

public class ValidationProcessor
implements MsgIdConstants,
ValidationTraceIF,
LoggingEnabledIF {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/validate/ValidationProcessor.java#2 $";
    private LoggerIF log = new NullLogger();

    public ValidationProcessor() {
    }

    public ValidationProcessor(LoggerIF logger) {
        this.setLogger(logger);
    }

    public void validate(ValidateableIF validateable, Collection validators) throws ValidationException, ValidationFailureException {
        trc.entering(this.getClass(), "validate");
        if (validateable == null || validators == null) {
            throw new ValidationFailureException("msg.tools.validate.002", "validateable==null:" + (validateable == null) + "(validators==null):" + (validators == null));
        }
        trc.info(this.getClass(), "Validating validatable: {0} with Collection of {1} validators", validateable.getValidateableName(), "" + validators.size());
        ValidationException exception = new ValidationException();
        Iterator iter = validators.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ValidatorIF)) {
                throw new ValidationFailureException("msg.tools.validate.");
            }
            ValidatorIF validator = (ValidatorIF)obj;
            trc.info(this.getClass(), "Validating validatable: {0} with validator: {1}", validateable.getValidateableName(), validator.getName());
            if (!validator.validate(validateable.getValidateableValue())) {
                this.getLogger().info(this.getClass(), "msg.tools.validate.004", validateable.getValidateableName(), validator.getName());
                exception.addError(validator, validateable);
                continue;
            }
            this.getLogger().info(this.getClass(), "msg.tools.validate.005", validateable.getValidateableName(), validator.getName());
        }
        if (exception.containsErrors()) {
            throw exception;
        }
        trc.exiting(this.getClass());
    }

    public void validate(Collection validateables, ValidatorIF validator) throws ValidationException, ValidationFailureException {
        trc.entering(this.getClass(), "validate");
        if (validateables == null || validator == null) {
            throw new ValidationFailureException("msg.tools.validate.002", "validateable==null:" + (validateables == null) + "(validators==null):" + (validator == null));
        }
        trc.info(this.getClass(), "Validating {0} validatables with validator: {1}", "" + validateables.size(), validator.getName());
        ValidationException exception = new ValidationException();
        Iterator iter = validateables.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (!(obj instanceof ValidateableIF)) {
                throw new ValidationFailureException("msg.tools.validate.");
            }
            ValidateableIF validateable = (ValidateableIF)obj;
            trc.info(this.getClass(), "Validating validatable: {0} with validator: {1}", validateable.getValidateableName(), validator.getName());
            if (!validator.validate(validateable.getValidateableValue())) {
                this.getLogger().info(this.getClass(), "msg.tools.validate.004", validateable.getValidateableName(), validator.getName());
                exception.addError(validator, validateable);
                continue;
            }
            this.getLogger().info(this.getClass(), "msg.tools.validate.005", validateable.getValidateableName(), validator.getName());
        }
        if (exception.containsErrors()) {
            throw exception;
        }
        trc.exiting(this.getClass());
    }

    public LoggerIF getLogger() {
        return this.log;
    }

    public void setLogger(LoggerIF logger) {
        this.log = logger;
    }
}

