/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.validate;

import com.sap.sdt.util.misc.StringHelper;
import com.sap.sdt.util.validate.ValidateableIF;
import com.sap.sdt.util.validate.ValidationConstants;
import com.sap.sdt.util.validate.ValidatorIF;

public class ValidationError
implements ValidationConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/validate/ValidationError.java#2 $";
    private String validatorMessage = null;
    private String validatorName = null;
    private ValidateableIF validateble = null;

    public ValidationError(ValidatorIF validator, ValidateableIF validateable) {
        this.setValidateble(validateable);
        this.setValidatorMessage(validator.getErrorMessage());
        this.setValidatorName(validator.getName());
        this.replaceTemplates(validator, validateable);
    }

    public ValidationError(ValidateableIF validateable, String message, String validatorName) {
        this.setValidateble(validateable);
        this.setValidatorMessage(message);
        this.setValidatorName(validatorName);
    }

    public ValidateableIF getValidateble() {
        return this.validateble;
    }

    public String getValidatorMessage() {
        return this.validatorMessage;
    }

    public String getValidatorName() {
        return this.validatorName;
    }

    public void setValidateble(ValidateableIF validateableIF) {
        this.validateble = validateableIF;
    }

    public void setValidatorMessage(String string) {
        this.validatorMessage = string;
    }

    public void setValidatorName(String string) {
        this.validatorName = string;
    }

    private void replaceTemplates(ValidatorIF validator, ValidateableIF validateable) {
        String buffer = StringHelper.replace(this.getValidatorMessage(), "TEMPLATE(field.name)", validateable.getValidateableName());
        buffer = StringHelper.replace(buffer, "TEMPLATE(validator.name)", validator.getName());
        buffer = StringHelper.replace(buffer, "TEMPLATE(field.value)", validateable.getValidateableValue().toString());
        this.setValidatorMessage(buffer.toString());
    }
}

