/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.string;

public class StringAnalyser {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/string/StringAnalyser.java#2 $";

    public static int[] getPositions(String buffer, char separator) {
        if (buffer == null) {
            return null;
        }
        int cnt = 0;
        int n = 0;
        n = 0;
        for (cnt = 0; cnt < buffer.length(); ++cnt) {
            if (buffer.charAt(cnt) != separator) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] positions = new int[n];
        n = 0;
        for (cnt = 0; cnt < buffer.length(); ++cnt) {
            if (buffer.charAt(cnt) != separator) continue;
            positions[n++] = cnt;
        }
        return positions;
    }

    public static int[] getPositions(String buffer, char[] seps) {
        if (buffer == null) {
            return null;
        }
        int cnt = 0;
        int n = 0;
        n = 0;
        for (cnt = 0; cnt < buffer.length(); ++cnt) {
            if (!StringAnalyser.arrayContainsChar(seps, buffer.charAt(cnt))) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        int[] positions = new int[n];
        n = 0;
        for (cnt = 0; cnt < buffer.length(); ++cnt) {
            if (!StringAnalyser.arrayContainsChar(seps, buffer.charAt(cnt))) continue;
            positions[n++] = cnt;
        }
        return positions;
    }

    public static boolean arrayContainsChar(char[] array, char single) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != single) continue;
            return true;
        }
        return false;
    }

    public static int[][] getWordPositions(char[] buffC, char separator) {
        return StringAnalyser.getWordPositions(buffC, separator, buffC.length);
    }

    public static int[][] getWordPositions(char[] buffC, char separator, int size) {
        if (buffC == null) {
            return null;
        }
        int cnt = 0;
        int noOfWords = 0;
        int[][] pos = new int[size][2];
        boolean insideWord = false;
        for (cnt = 0; cnt < buffC.length && buffC[cnt] != '\n'; ++cnt) {
            if (buffC[cnt] == separator) {
                if (!insideWord) continue;
                pos[noOfWords][1] = cnt;
                insideWord = false;
                ++noOfWords;
                continue;
            }
            if (insideWord) continue;
            pos[noOfWords][0] = cnt;
            insideWord = true;
        }
        if (insideWord) {
            pos[noOfWords][1] = cnt;
            insideWord = false;
            ++noOfWords;
        }
        if (noOfWords == 0) {
            return null;
        }
        if (noOfWords == size) {
            return pos;
        }
        int[][] posF = new int[noOfWords][2];
        for (cnt = 0; cnt < noOfWords; ++cnt) {
            posF[cnt][0] = pos[cnt][0];
            posF[cnt][1] = pos[cnt][1];
        }
        return posF;
    }

    public static boolean containsOnly(String buffer, String allowedChars) {
        return StringAnalyser.containsOnly(buffer, allowedChars.toCharArray());
    }

    public static boolean containsOnly(String buffer, char[] allowedChars) {
        return StringAnalyser.getFirstDifferent(buffer, allowedChars) == buffer.length();
    }

    public static int getFirstDifferent(String buffer, char[] allowedChars) {
        return StringAnalyser.getFirstDifferent(buffer, 0, allowedChars);
    }

    public static int getFirstDifferent(String buffer, int start, char[] allowedChars) {
        if (buffer == null) {
            return 0;
        }
        int aCnt = 0;
        int bCnt = 0;
        aCnt = 0;
        block0: for (bCnt = start; bCnt < buffer.length(); ++bCnt) {
            if (buffer.charAt(bCnt) == allowedChars[aCnt]) continue;
            for (aCnt = 0; aCnt < allowedChars.length; ++aCnt) {
                if (buffer.charAt(bCnt) == allowedChars[aCnt]) continue block0;
            }
        }
        return bCnt;
    }

    public static int getFirstDifferent(String buffer, char allowedChar) {
        return StringAnalyser.getFirstDifferent(buffer, 0, allowedChar);
    }

    public static int getFirstDifferent(String buffer, int start, char allowedChar) {
        if (buffer == null) {
            return 0;
        }
        int bCnt = 0;
        for (bCnt = start; bCnt < buffer.length() && buffer.charAt(bCnt) == allowedChar; ++bCnt) {
        }
        return bCnt;
    }

    public static int getFirstNonSpace(String buffer) {
        return StringAnalyser.getFirstNonSpace(buffer, 0);
    }

    public static int getFirstNonSpace(String buffer, int start) {
        if (buffer == null) {
            return 0;
        }
        int bCnt = 0;
        for (bCnt = start; bCnt < buffer.length() && Character.isWhitespace(buffer.charAt(bCnt)); ++bCnt) {
        }
        return bCnt;
    }

    public static int getLastDifferent(String buffer, char allowedChar) {
        if (buffer == null) {
            return 0;
        }
        int bCnt = 0;
        for (bCnt = buffer.length() - 1; bCnt >= 0 && buffer.charAt(bCnt) == allowedChar; --bCnt) {
        }
        return bCnt;
    }

    public static int countCharsContained(String buffer, char allowedChar) {
        if (buffer == null) {
            return 0;
        }
        int aCnt = 0;
        int bCnt = 0;
        aCnt = 0;
        for (bCnt = 0; bCnt < buffer.length(); ++bCnt) {
            if (buffer.charAt(bCnt) != allowedChar) continue;
            ++aCnt;
        }
        return aCnt;
    }

    public static boolean isInitial(String str, boolean nullIsInitial, boolean blankIsInitial) {
        if (str == null) {
            return nullIsInitial;
        }
        if (str.length() <= 0) {
            return true;
        }
        if (!blankIsInitial) {
            return false;
        }
        String trimmedString = str.trim();
        return trimmedString.length() <= 0;
    }
}

