/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.string;

import com.sap.sdt.util.diag.DiagException;
import com.sap.sdt.util.diag.FileIOException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;

public class ShellStringTokenizer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/string/ShellStringTokenizer.java#2 $";
    private static final String ESCAPE_CHARACTERS = "\\\"'";
    Reader reader;
    String separators;

    public ShellStringTokenizer(String line, String separators) {
        this(new StringReader(line), separators);
    }

    public ShellStringTokenizer(String line) {
        this(line, null);
    }

    public ShellStringTokenizer(Reader reader, String separators) {
        this.reader = reader;
        this.separators = separators;
    }

    public ShellStringTokenizer(Reader reader) {
        this(reader, null);
    }

    public ShellStringTokenizer(InputStream in, String separators) {
        this(new InputStreamReader(in), separators);
    }

    public ShellStringTokenizer(InputStream in) {
        this(new InputStreamReader(in));
    }

    public void close() throws DiagException {
        try {
            this.reader.close();
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
    }

    public void setSeparators(String separators) {
        this.separators = separators;
    }

    public String getToken() throws FileIOException {
        try {
            return this.getToken2();
        }
        catch (IOException e) {
            throw new FileIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String getToken2() throws IOException {
        int c;
        StringBuffer buffer = new StringBuffer();
        int state = 0;
        block7: while ((c = this.reader.read()) != -1) {
            switch (state) {
                case 0: {
                    if (c == 34) {
                        state = 10;
                        continue block7;
                    }
                    if (c == 39) {
                        state = 20;
                        continue block7;
                    }
                    if (c == 92) {
                        state = 1;
                        continue block7;
                    }
                    if (this.separators != null && this.separators.indexOf((char)c) >= 0) break block7;
                    if (!Character.isWhitespace((char)c)) break;
                    if (buffer.length() <= 0) continue block7;
                    break block7;
                }
                case 1: {
                    if (ESCAPE_CHARACTERS.indexOf((char)c) < 0) {
                        buffer.append('\\');
                    }
                    state = 0;
                    break;
                }
                case 10: {
                    if (c == 34) {
                        state = 0;
                        continue block7;
                    }
                    if (c != 92) break;
                    state = 11;
                    continue block7;
                }
                case 11: {
                    state = 10;
                    break;
                }
                case 20: {
                    if (c != 39) break;
                    state = 0;
                    continue block7;
                }
            }
            buffer.append((char)c);
        }
        if (c == -1 && buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }

    public static String toShellString(String s) {
        if (s.indexOf(39) == -1) {
            return "'" + s + "'";
        }
        StringBuffer sb = new StringBuffer("\"");
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) == '\\' || s.charAt(i) == '\"') {
                sb.append('\\');
            }
            sb.append(s.charAt(i));
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String[] getWords(String line) throws FileIOException {
        return ShellStringTokenizer.getWords(line, null);
    }

    public static String[] getWords(String line, String separators) throws FileIOException {
        String word;
        Vector<String> words = new Vector<String>();
        ShellStringTokenizer tokenizer = new ShellStringTokenizer(line, separators);
        int n = 0;
        while ((word = tokenizer.getToken()) != null) {
            words.add(word);
            ++n;
        }
        if (n == 0) {
            return null;
        }
        return words.toArray(new String[n]);
    }
}

