/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.string;

import com.sap.sdt.util.string.StringAnalyser;
import java.util.Iterator;
import java.util.List;

public class SString
extends StringAnalyser {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/string/SString.java#2 $";

    public static String substChar(String buffer, char a, char b) {
        char[] out = new char[buffer.length()];
        for (int inx = 0; inx < buffer.length(); ++inx) {
            out[inx] = buffer.charAt(inx) == a ? b : buffer.charAt(inx);
        }
        return new String(out);
    }

    public static String substChar(String buffer, char[] a, char b) {
        char[] out = new char[buffer.length()];
        for (int inx = 0; inx < buffer.length(); ++inx) {
            out[inx] = SString.containsChar(a, buffer.charAt(inx)) ? b : buffer.charAt(inx);
        }
        return new String(out);
    }

    private static boolean containsChar(char[] a, char b) {
        if (a == null) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (b != a[i]) continue;
            return true;
        }
        return false;
    }

    public static String padWithChar(String buffer, int length, char padder) {
        int bLength;
        StringBuffer bBuffer = new StringBuffer(buffer);
        for (int inx = bLength = buffer.length(); inx < length; ++inx) {
            bBuffer.append(padder);
        }
        return bBuffer.toString();
    }

    public static String padWithBlank(String buffer, int length) {
        return SString.padWithChar(buffer, length, ' ');
    }

    public static String stripBlank(String buffer) {
        return buffer.substring(SString.getFirstDifferent(buffer, ' '), SString.getLastDifferent(buffer, ' ') + 1);
    }

    public static String stripTrailChar(String buffer, char stripper) {
        return buffer.substring(0, SString.getLastDifferent(buffer, stripper) + 1);
    }

    public static String condenseChars(String buffer, char separator) {
        if (buffer == null) {
            return null;
        }
        int[] pos = SString.getPositions(buffer, separator);
        if (pos == null || pos.length == 1) {
            return buffer;
        }
        String ret = null;
        ret = buffer.substring(0, pos[0]);
        for (int cnt = 1; cnt < pos.length; ++cnt) {
            if (pos[cnt] == pos[cnt - 1] + 1) continue;
            ret = ret + buffer.substring(pos[cnt - 1], pos[cnt]);
        }
        ret = ret + buffer.substring(pos[pos.length - 1], buffer.length());
        return ret;
    }

    public static String[] getSubStrings(String buffer, char separator) {
        if (buffer == null) {
            return null;
        }
        int[] pos = SString.getPositions(buffer, separator);
        return SString.getSubStringsOfPositions(buffer, pos);
    }

    public static String[] getSubStrings(String buffer, char[] separators) {
        if (buffer == null) {
            return null;
        }
        int[] pos = SString.getPositions(buffer, separators);
        return SString.getSubStringsOfPositions(buffer, pos);
    }

    public static String[] getSubStringsOfPositions(String buffer, int[] pos) {
        return SString.getSubStringsOfPositions(buffer, pos, false);
    }

    public static String[] getSubStringsOfPositions(String buffer, int[] pos, boolean withCharAtPos) {
        if (buffer == null) {
            return null;
        }
        if (pos == null) {
            String[] ret = new String[]{buffer};
            return ret;
        }
        String[] sub = new String[pos.length + 1];
        int buffLength = buffer.length();
        int offs = withCharAtPos ? 1 : 0;
        int last = 0;
        try {
            int cnt;
            for (cnt = 0; cnt < pos.length; ++cnt) {
                sub[cnt] = buffer.substring(last, pos[cnt] + offs);
                if (sub[cnt] == null) {
                    sub[cnt] = "";
                }
                if ((last = pos[cnt] + 1) <= buffLength) continue;
                last = buffLength;
                break;
            }
            if (last != buffLength) {
                sub[cnt] = buffer.substring(last, buffLength);
            }
            if (sub[cnt] == null) {
                sub[cnt] = "";
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new Error("ERROR: com.sap.sdt.util.misc.SString.getSubStringsOfPositions (" + buffer + "," + pos + "):\n" + "       message:" + ex.getMessage());
        }
        return sub;
    }

    public static String[] getPartsOfEquation(String line) {
        if (line == null) {
            return new String[]{null, null};
        }
        int length = line.length();
        int posOfEq = line.indexOf(61);
        String[] ret = new String[2];
        String name = null;
        if (posOfEq < 0) {
            name = SString.stripBlank(line);
            ret[0] = name == null || name.length() <= 0 ? null : name;
            ret[1] = null;
        } else {
            name = SString.stripBlank(line.substring(0, posOfEq));
            ret[0] = name == null || name.length() <= 0 ? null : name;
            ret[1] = SString.stripBlank(line.substring(posOfEq + 1, length));
        }
        return ret;
    }

    public static String stripBlankAndQuote(String buffer) {
        if (buffer == null) {
            return buffer;
        }
        int first = SString.getFirstDifferent(buffer, ' ');
        int last = SString.getLastDifferent(buffer, ' ');
        if (buffer.charAt(first) == '\"' && buffer.charAt(last) == '\"') {
            ++first;
            --last;
        } else if (buffer.charAt(first) == '\'' && buffer.charAt(last) == '\'') {
            ++first;
            --last;
        }
        return buffer.substring(first, last + 1);
    }

    public static String stripExtension(String buffer, char x) {
        if (buffer == null) {
            return buffer;
        }
        int pos = buffer.lastIndexOf(x);
        if (pos <= 0) {
            return buffer;
        }
        return buffer.substring(pos - 1);
    }

    public static String stripExtension(String buffer) {
        return SString.stripExtension(buffer, '.');
    }

    public static String toCommaString(String[] words) {
        return SString.toSeparatedString(words, ',');
    }

    public static String toCommaString(List words) {
        return SString.toSeparatedString(words, ',');
    }

    public static String toSeparatedString(String[] words, char sep) {
        if (words == null || words.length == 0) {
            return "";
        }
        String val = words[0];
        for (int i = 1; i < words.length; ++i) {
            val = val + sep + words[i];
        }
        return val;
    }

    public static String toSeparatedString(List words, char sep) {
        if (words == null || words.size() == 0) {
            return "";
        }
        String word = null;
        String val = null;
        Iterator it = words.iterator();
        while (it.hasNext()) {
            word = it.next().toString();
            if (val == null) {
                val = word;
                continue;
            }
            val = val + sep + word;
        }
        return val;
    }

    public static String condenseWhitespace(String string) {
        string = string.trim();
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) {
                while (Character.isWhitespace(string.charAt(++i))) {
                }
                buffer.append(' ');
            }
            buffer.append(string.charAt(i));
        }
        if (buffer.length() == 0) {
            return null;
        }
        return buffer.toString();
    }
}

