/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.string;

import com.sap.sdt.util.string.IncompletePairException;
import com.sap.sdt.util.string.PairPositions;
import com.sap.sdt.util.string.PairSearcher;
import java.util.Iterator;

public class PairSearcherNumber
extends PairSearcher {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/string/PairSearcherNumber.java#2 $";

    public PairSearcherNumber(String _src) {
        super(_src);
    }

    public PairSearcherNumber(String _src, String start, String stop) throws IncompletePairException {
        super(_src, start, stop);
    }

    public int getEnclosedInt(int nr) throws NumberFormatException {
        String number = this.getEnclosedString(nr);
        if (number == null) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(number);
    }

    public int getNrOfHitEnclosing(int nr) {
        String nrStr = Integer.toString(nr);
        return this.getNrOfHitEnclosing(nrStr);
    }

    public String replaceHits(String[] subst) {
        if (this.getSource() == null) {
            return null;
        }
        if (this.getNumberOfHits() <= 0) {
            return this.getSource();
        }
        int hitInx = 0;
        int enclosedNr = 0;
        int currentPos = 0;
        PairPositions pp = null;
        StringBuffer result = new StringBuffer();
        Iterator it = this.getHitIterator();
        if (it == null) {
            return this.getSource();
        }
        String src = this.getSource();
        hitInx = 0;
        while (it.hasNext() && (pp = (PairPositions)it.next()) != null) {
            result.append(src.substring(currentPos, pp.getStartPos1()));
            try {
                enclosedNr = this.getEnclosedInt(hitInx);
            }
            catch (NumberFormatException ex) {
                enclosedNr = -1;
            }
            if (enclosedNr >= 0 && enclosedNr < subst.length) {
                result.append(subst[enclosedNr]);
            } else {
                result.append(src.substring(pp.getStartPos1(), pp.getStopPos2()));
            }
            currentPos = pp.getStopPos2();
            ++hitInx;
        }
        result.append(src.substring(currentPos));
        return result.toString();
    }
}

