/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.string;

import com.sap.sdt.util.string.IncompletePairException;
import com.sap.sdt.util.string.PairPositions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class PairSearcher {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/string/PairSearcher.java#2 $";
    private String src = null;
    private List hits = null;

    public PairSearcher(String _src) {
        this.src = _src;
    }

    public PairSearcher(String _src, String _startPat, String _stopPat) throws IncompletePairException {
        this.src = _src;
        int nr = this.search(_startPat, _stopPat);
    }

    public String getSource() {
        return this.src;
    }

    public int getNumberOfHits() {
        if (this.hits == null) {
            return -1;
        }
        return this.hits.size();
    }

    public PairPositions getHitNumber(int nr) {
        if (this.hits == null) {
            return null;
        }
        return (PairPositions)this.hits.get(nr);
    }

    public int getNrOfHitEnclosing(String str) {
        int max = this.getNumberOfHits();
        for (int i = 0; i < max; ++i) {
            if (!str.equals(this.getEnclosedString(i))) continue;
            return i;
        }
        return -1;
    }

    public int search(String startPat, String stopPat) throws IncompletePairException {
        int startPos = 0;
        int startLen = startPat.length();
        int stopPos = 0;
        int stopLen = stopPat.length();
        int nrHits = 0;
        PairPositions pp = null;
        boolean done = false;
        if (this.src == null) {
            return -1;
        }
        this.hits = new LinkedList();
        while ((startPos = this.src.indexOf(startPat, startPos)) >= 0) {
            stopPos = this.src.indexOf(stopPat, startPos + startLen);
            if (stopPos < 0) {
                throw new IncompletePairException("Pair number " + Integer.toString(nrHits) + " is incomplete.");
            }
            pp = new PairPositions(startPos, startPos + startLen, stopPos, stopPos + stopLen);
            this.hits.add(pp);
            ++nrHits;
            startPos = stopPos + stopLen;
            if (!done) continue;
        }
        return nrHits;
    }

    public Iterator getHitIterator() {
        if (this.hits == null) {
            return null;
        }
        return this.hits.iterator();
    }

    public String getEnclosedString(int nr) {
        PairPositions pp = null;
        if (this.hits == null) {
            return null;
        }
        pp = (PairPositions)this.hits.get(nr);
        if (pp == null) {
            return null;
        }
        return this.src.substring(pp.getStopPos1(), pp.getStartPos2());
    }
}

