/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.SerialConstants;

class TypeMapper
implements SerialConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/TypeMapper.java#2 $";
    private static String[] typeMap = new String[20];
    private static Class[] classMap = new Class[11];

    TypeMapper() {
    }

    public static int getType(String name) {
        int type = -1;
        for (int i = 0; i < 20; ++i) {
            if (!name.equals(typeMap[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    public static String getName(int type) {
        String name = null;
        if (type > -1 && type < 20) {
            name = typeMap[type];
        }
        return name;
    }

    public static Class getPrimitiveClass(int type) {
        Class cls = null;
        if (type > -1 && type < 11) {
            cls = classMap[type];
        }
        return cls;
    }

    public static int getPrimitiveType(Class cls) {
        int type = -1;
        for (int i = 0; i < 11; ++i) {
            if (!cls.equals(classMap[i])) continue;
            type = i;
            break;
        }
        return type;
    }

    static {
        TypeMapper.typeMap[1] = "void";
        TypeMapper.typeMap[2] = "boolean";
        TypeMapper.typeMap[3] = "char";
        TypeMapper.typeMap[4] = "byte";
        TypeMapper.typeMap[5] = "short";
        TypeMapper.typeMap[6] = "int";
        TypeMapper.typeMap[7] = "long";
        TypeMapper.typeMap[8] = "float";
        TypeMapper.typeMap[9] = "double";
        TypeMapper.typeMap[10] = "java.lang.Void";
        TypeMapper.typeMap[11] = "java.lang.Boolean";
        TypeMapper.typeMap[12] = "java.lang.Character";
        TypeMapper.typeMap[13] = "java.lang.Byte";
        TypeMapper.typeMap[14] = "java.lang.Short";
        TypeMapper.typeMap[15] = "java.lang.Integer";
        TypeMapper.typeMap[16] = "java.lang.Long";
        TypeMapper.typeMap[17] = "java.lang.Float";
        TypeMapper.typeMap[18] = "java.lang.Double";
        TypeMapper.typeMap[19] = "java.lang.String";
        TypeMapper.classMap[1] = Void.TYPE;
        TypeMapper.classMap[2] = Boolean.TYPE;
        TypeMapper.classMap[3] = Character.TYPE;
        TypeMapper.classMap[4] = Byte.TYPE;
        TypeMapper.classMap[5] = Short.TYPE;
        TypeMapper.classMap[6] = Integer.TYPE;
        TypeMapper.classMap[7] = Long.TYPE;
        TypeMapper.classMap[8] = Float.TYPE;
        TypeMapper.classMap[9] = Double.TYPE;
    }
}

