/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.misc.JavaRuntime;
import com.sap.sdt.util.serial.FieldNotFoundException;
import com.sap.sdt.util.serial.SecurityViolationException;
import com.sap.sdt.util.serial.SerialConstants;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.TypeMapper;
import com.sap.sdt.util.xml.XMLAdmin;
import com.sap.sdt.util.xml.XMLElementIF;
import java.io.ObjectInputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;

final class SerialToolkit
implements SerialConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/SerialToolkit.java#2 $";
    public static final XMLElementIF NULL_ELEMENT = SerialToolkit.createNullElem();
    private static final String SEPARATOR = "$";
    private static final String REFL_FACTORY = "sun.reflect.ReflectionFactory";
    private static final String REFL_ACTION = "GetReflectionFactoryAction";
    private static final String CTOR14 = "newConstructorForSerialization";
    private static final String CTOR13 = "allocateNewObject";
    private static final String OBJ_STREAM_CLS = "java.io.ObjectStreamClass";
    private static final String FIELD_REFLECTOR = "FieldReflector";
    private static final String UNSAFE = "unsafe";

    private SerialToolkit() {
    }

    public static Object create(Class cls) throws SerialException {
        Object obj = null;
        obj = JavaRuntime.isRequiredVersion(new int[]{1, 4}) ? SerialToolkit.create14(cls) : SerialToolkit.create13(cls);
        return obj;
    }

    public static Field getField(Object obj, String fieldName) throws SerialException {
        Field field = null;
        for (Class<?> cls = obj.getClass(); cls != null; cls = cls.getSuperclass()) {
            try {
                field = cls.getDeclaredField(fieldName);
                continue;
            }
            catch (NoSuchFieldException nsfE) {
                // empty catch block
            }
        }
        if (field == null) {
            String className = obj.getClass().getName();
            throw new FieldNotFoundException(className, fieldName);
        }
        return field;
    }

    public static Object getValue(Object target, String fieldName) throws SerialException {
        try {
            Field field = SerialToolkit.getField(target, fieldName);
            field.setAccessible(true);
            return field.get(target);
        }
        catch (IllegalAccessException iaE) {
            throw new SerialException(new JavaException(iaE));
        }
    }

    public static void setValue(Object target, Object value, String fieldName) throws SerialException {
        if (JavaRuntime.isRequiredVersion(new int[]{1, 4})) {
            SerialToolkit.setValue14(target, value, fieldName);
        } else {
            SerialToolkit.setValue13(target, value, fieldName);
        }
    }

    private static Object create13(Class cls) throws SerialException {
        Class ioCls = ObjectInputStream.class;
        Class[] paramTypes = new Class[]{Class.class, Class.class};
        Method method = SerialToolkit.getMethod(ioCls, CTOR13, paramTypes);
        method.setAccessible(true);
        Object[] params = new Object[]{cls, Object.class};
        return SerialToolkit.invoke(method, null, params);
    }

    private static Object create14(Class cls) throws SerialException {
        try {
            Constructor ctor = null;
            Class<?> fC = Class.forName(REFL_FACTORY);
            Class<?> aC = Class.forName("sun.reflect.ReflectionFactory$GetReflectionFactoryAction");
            PrivilegedAction pA = (PrivilegedAction)aC.newInstance();
            Object factory = AccessController.doPrivileged(pA);
            Class initCl = Object.class;
            ctor = initCl.getDeclaredConstructor(new Class[0]);
            Class[] params = new Class[]{Class.class, Constructor.class};
            Method method = SerialToolkit.getMethod(fC, CTOR14, params);
            method.setAccessible(true);
            Object[] args = new Object[]{cls, ctor};
            ctor = (Constructor)SerialToolkit.invoke(method, factory, args);
            ctor.setAccessible(true);
            return ctor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException cnfE) {
            throw new SerialException(new JavaException(cnfE));
        }
        catch (InstantiationException iE) {
            throw new SerialException(new JavaException(iE));
        }
        catch (IllegalAccessException iacE) {
            throw new SerialException(new JavaException(iacE));
        }
        catch (SecurityException sE) {
            throw new SecurityViolationException(new JavaException(sE));
        }
        catch (NoSuchMethodException nsmE) {
            throw new SerialException(new JavaException(nsmE));
        }
        catch (IllegalArgumentException iarE) {
            throw new SerialException(new JavaException(iarE));
        }
        catch (InvocationTargetException itE) {
            throw new SerialException(new JavaException(itE));
        }
    }

    private static void setValue13(Object target, Object value, String fieldName) throws SerialException {
        try {
            Field field = SerialToolkit.getField(target, fieldName);
            field.setAccessible(true);
            field.set(target, value);
        }
        catch (IllegalArgumentException iarE) {
            throw new SerialException(new JavaException(iarE));
        }
        catch (IllegalAccessException iacE) {
            throw new SerialException(new JavaException(iacE));
        }
    }

    private static void setValue14(Object target, Object value, String fieldName) throws SerialException {
        try {
            Field field = SerialToolkit.getField(target, fieldName);
            if (!Modifier.isFinal(field.getModifiers())) {
                field.setAccessible(true);
                field.set(target, value);
            } else {
                Class<?> type = field.getType();
                if (type.isPrimitive()) {
                    switch (TypeMapper.getPrimitiveType(type)) {
                        case 6: {
                            SerialToolkit.set(target, field, (Integer)value);
                            break;
                        }
                        case 7: {
                            SerialToolkit.set(target, field, (Long)value);
                            break;
                        }
                        case 5: {
                            SerialToolkit.set(target, field, (Short)value);
                            break;
                        }
                        case 3: {
                            SerialToolkit.set(target, field, (Character)value);
                            break;
                        }
                        case 4: {
                            SerialToolkit.set(target, field, (Byte)value);
                            break;
                        }
                        case 8: {
                            SerialToolkit.set(target, field, (Float)value);
                            break;
                        }
                        case 9: {
                            SerialToolkit.set(target, field, (Double)value);
                            break;
                        }
                        case 2: {
                            SerialToolkit.set(target, field, (Boolean)value);
                            break;
                        }
                    }
                } else {
                    SerialToolkit.set(target, field, value);
                }
            }
        }
        catch (IllegalArgumentException iarE) {
            throw new SerialException(new JavaException(iarE));
        }
        catch (IllegalAccessException iacE) {
            throw new SerialException(new JavaException(iacE));
        }
    }

    private static void set(Object target, Field field, Integer value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Integer.TYPE};
        SerialToolkit.set(target, field, "putInt", params, value);
    }

    private static void set(Object target, Field field, Short value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Short.TYPE};
        SerialToolkit.set(target, field, "putShort", params, value);
    }

    private static void set(Object target, Field field, Long value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Long.TYPE};
        SerialToolkit.set(target, field, "putLong", params, value);
    }

    private static void set(Object target, Field field, Character value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Character.TYPE};
        SerialToolkit.set(target, field, "putChar", params, value);
    }

    private static void set(Object target, Field field, Byte value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Byte.TYPE};
        SerialToolkit.set(target, field, "putByte", params, value);
    }

    private static void set(Object target, Field field, Float value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Float.TYPE};
        SerialToolkit.set(target, field, "putFloat", params, value);
    }

    private static void set(Object target, Field field, Double value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Double.TYPE};
        SerialToolkit.set(target, field, "putDouble", params, value);
    }

    private static void set(Object target, Field field, Boolean value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Boolean.TYPE};
        SerialToolkit.set(target, field, "putBoolean", params, value);
    }

    private static void set(Object target, Field field, Object value) throws SerialException {
        Class[] params = new Class[]{Object.class, Long.TYPE, Object.class};
        SerialToolkit.set(target, field, "putObject", params, value);
    }

    private static void set(Object target, Field field, String name, Class[] params, Object value) throws SerialException {
        Object unsafe = SerialToolkit.getUnsafe();
        Class<?> unsafeCls = unsafe.getClass();
        Method method = SerialToolkit.getMethod(unsafeCls, name, params);
        SerialToolkit.invoke(method, unsafe, new Object[]{target, SerialToolkit.getOffset(field), value});
    }

    private static Long getOffset(Field field) throws SerialException {
        Object unsafe = SerialToolkit.getUnsafe();
        Class<?> unsafeCls = unsafe.getClass();
        Class[] params = new Class[]{Field.class};
        Method method = SerialToolkit.getMethod(unsafeCls, "objectFieldOffset", params);
        return (Long)SerialToolkit.invoke(method, unsafe, new Object[]{field});
    }

    private static Object getUnsafe() throws SerialException {
        try {
            String clsName = "java.io.ObjectStreamClass$FieldReflector";
            Class<?> objectStreamClass = Class.forName(clsName);
            Field unsafeField = objectStreamClass.getDeclaredField(UNSAFE);
            unsafeField.setAccessible(true);
            return unsafeField.get(null);
        }
        catch (ClassNotFoundException cnfE) {
            throw new SerialException(new JavaException(cnfE));
        }
        catch (SecurityException sE) {
            throw new SerialException(new JavaException(sE));
        }
        catch (NoSuchFieldException nsfE) {
            throw new SerialException(new JavaException(nsfE));
        }
        catch (IllegalArgumentException iarE) {
            throw new SerialException(new JavaException(iarE));
        }
        catch (IllegalAccessException iacE) {
            throw new SerialException(new JavaException(iacE));
        }
    }

    private static Method getMethod(Class cls, String name, Class[] params) throws SerialException {
        try {
            return cls.getDeclaredMethod(name, params);
        }
        catch (SecurityException sE) {
            throw new SerialException(new JavaException(sE));
        }
        catch (NoSuchMethodException nsmE) {
            throw new SerialException(new JavaException(nsmE));
        }
    }

    private static Object invoke(Method method, Object target, Object[] args) throws SerialException {
        try {
            return method.invoke(target, args);
        }
        catch (IllegalArgumentException iarE) {
            throw new SerialException(new JavaException(iarE));
        }
        catch (IllegalAccessException iacE) {
            throw new SerialException(new JavaException(iacE));
        }
        catch (InvocationTargetException itE) {
            throw new SerialException(new JavaException(itE));
        }
    }

    private static XMLElementIF createNullElem() {
        XMLElementIF nE = XMLAdmin.createXMLElement();
        nE.setName("_null");
        return nE;
    }
}

