/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.ArraySerializer;
import com.sap.sdt.util.serial.DefaultSerializer;
import com.sap.sdt.util.serial.ExternalIF;
import com.sap.sdt.util.serial.ExternalSerializer;
import com.sap.sdt.util.serial.ObjectSerializer;
import com.sap.sdt.util.serial.PrimitiveSerializer;
import com.sap.sdt.util.serial.SerialConstants;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.TypeMapper;
import com.sap.sdt.util.serial.Uid;
import java.lang.reflect.Field;

final class SerialTarget
implements SerialConstants {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/SerialTarget.java#2 $";
    private static final String FIELD_ROOT = "root";
    private static final String FIELD_BASE = "base";
    private SerialID serialID = null;
    private Uid uid = null;
    private int typeID = -1;
    private String typeName = null;
    private String compName = null;
    private String fieldName = null;
    private boolean booleanVal = false;
    private char charVal = (char)32;
    private byte byteVal = 0;
    private short shortVal = 0;
    private int intVal = 0;
    private long longVal = 0L;
    private float floatVal = 0.0f;
    private double doubleVal = 0.0;
    private Object objVal = null;
    private Field field = null;
    private boolean isArray = false;
    private boolean isPrimitive = false;
    private boolean isSerializable = true;
    private boolean isBaseClass = false;

    SerialTarget(boolean val) {
        this.booleanVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 2;
        this.initFromPrimitive();
    }

    SerialTarget(char val) {
        this.charVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 3;
        this.initFromPrimitive();
    }

    SerialTarget(byte val) {
        this.byteVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 4;
        this.initFromPrimitive();
    }

    SerialTarget(short val) {
        this.shortVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 5;
        this.initFromPrimitive();
    }

    SerialTarget(int val) {
        this.intVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 6;
        this.initFromPrimitive();
    }

    SerialTarget(long val) {
        this.longVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 7;
        this.initFromPrimitive();
    }

    SerialTarget(float val) {
        this.floatVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 8;
        this.initFromPrimitive();
    }

    SerialTarget(double val) {
        this.doubleVal = val;
        this.fieldName = FIELD_ROOT;
        this.typeID = 9;
        this.initFromPrimitive();
    }

    SerialTarget(Object obj) {
        this.objVal = obj;
        this.fieldName = FIELD_ROOT;
        this.initFromObject();
    }

    SerialTarget(Object parent, Field field) throws SerialException {
        this.field = field;
        this.isPrimitive = field.getType().isPrimitive();
        this.fieldName = field.getName();
        field.setAccessible(true);
        try {
            if (this.isPrimitive) {
                this.typeID = TypeMapper.getType(field.getType().getName());
                switch (this.typeID) {
                    case 2: {
                        this.booleanVal = field.getBoolean(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 3: {
                        this.charVal = field.getChar(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 4: {
                        this.byteVal = field.getByte(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 5: {
                        this.shortVal = field.getShort(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 6: {
                        this.intVal = field.getInt(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 7: {
                        this.longVal = field.getLong(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 8: {
                        this.floatVal = field.getFloat(parent);
                        this.initFromPrimitive();
                        break;
                    }
                    case 9: {
                        this.doubleVal = field.getDouble(parent);
                        this.initFromPrimitive();
                        break;
                    }
                }
            } else {
                this.objVal = field.get(parent);
                this.initFromObject();
            }
        }
        catch (IllegalAccessException iaE) {
            throw new SerialException(new JavaException(iaE));
        }
    }

    SerialTarget(Object val, Class cls, Uid uid) {
        this.objVal = val;
        this.uid = uid;
        this.typeName = cls.getName();
        this.fieldName = FIELD_BASE;
        this.isBaseClass = true;
    }

    public Object getObject() {
        return this.objVal;
    }

    String getObjectValue() {
        String value = null;
        switch (this.typeID) {
            case 2: {
                value = this.booleanVal ? "true" : "false";
                break;
            }
            case 3: {
                value = "" + this.charVal;
                break;
            }
            case 4: {
                value = Byte.toString(this.byteVal);
                break;
            }
            case 5: {
                value = Short.toString(this.shortVal);
                break;
            }
            case 6: {
                value = Integer.toString(this.intVal);
                break;
            }
            case 7: {
                value = Long.toString(this.longVal);
                break;
            }
            case 8: {
                value = Float.toString(this.floatVal);
                break;
            }
            case 9: {
                value = Double.toString(this.doubleVal);
                break;
            }
            default: {
                value = this.objVal.toString();
            }
        }
        return value;
    }

    Uid getUid() {
        return this.uid;
    }

    void setUid(Uid uid) {
        this.uid = uid;
    }

    int getTypeID() {
        return this.typeID;
    }

    String getTypeName() {
        return this.typeName;
    }

    String getCompName() {
        return this.compName;
    }

    String getFieldName() {
        return this.fieldName;
    }

    SerialID getSerialID() {
        return this.serialID;
    }

    boolean isSerializable() {
        return this.isSerializable;
    }

    boolean isPrimitive() {
        return this.isPrimitive;
    }

    boolean isBaseClass() {
        return this.isBaseClass;
    }

    private void initFromPrimitive() {
        this.uid = new Uid();
        this.isPrimitive = true;
        this.typeName = TypeMapper.getName(this.typeID);
        this.generateSerialID();
    }

    private void initFromObject() {
        if (this.objVal == null) {
            this.isSerializable = false;
        } else {
            this.uid = new Uid();
            this.isArray = this.objVal.getClass().isArray();
            this.typeName = this.objVal.getClass().getName();
            this.typeID = TypeMapper.getType(this.typeName);
            if (this.isArray) {
                this.compName = this.objVal.getClass().getComponentType().getName();
            }
            this.generateSerialID();
        }
    }

    private void generateSerialID() {
        if (this.isArray) {
            this.serialID = ArraySerializer.instance().getSerialID();
            return;
        }
        if (this.isPrimitive) {
            this.serialID = PrimitiveSerializer.instance().getSerialID();
            return;
        }
        if (this.objVal instanceof ExternalIF) {
            this.serialID = ExternalSerializer.instance().getSerialID();
            return;
        }
        switch (this.typeID) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.serialID = ObjectSerializer.instance().getSerialID();
                break;
            }
            default: {
                this.serialID = DefaultSerializer.instance().getSerialID();
            }
        }
    }
}

