/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.TypeMapper;
import com.sap.sdt.util.serial.TypeMappingNotFoundException;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;

class PrimitiveDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/PrimitiveDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("Primitive");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    PrimitiveDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new PrimitiveDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        Comparable<Boolean> obj = null;
        XMLElementIF rootElem = ta.getXML();
        try {
            String typeName = rootElem.getAttrString("_type");
            int type = TypeMapper.getType(typeName);
            switch (type) {
                case 2: {
                    obj = new Boolean(this.getValue(rootElem));
                    break;
                }
                case 3: {
                    char c = this.getValue(rootElem).charAt(0);
                    obj = new Character(c);
                    break;
                }
                case 4: {
                    obj = new Byte(this.getValue(rootElem));
                    break;
                }
                case 5: {
                    obj = new Short(this.getValue(rootElem));
                    break;
                }
                case 6: {
                    obj = new Integer(this.getValue(rootElem));
                    break;
                }
                case 7: {
                    obj = new Long(this.getValue(rootElem));
                    break;
                }
                case 8: {
                    obj = new Float(this.getValue(rootElem));
                    break;
                }
                case 9: {
                    obj = new Double(this.getValue(rootElem));
                    break;
                }
                default: {
                    throw new TypeMappingNotFoundException(typeName);
                }
            }
        }
        catch (XMLException xmlE) {
            throw new SerialException(xmlE);
        }
        return obj;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
    }
}

