/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.TypeMapper;
import com.sap.sdt.util.serial.TypeMappingNotFoundException;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;

class ObjectDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/ObjectDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("Object");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    ObjectDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new ObjectDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        Object obj = null;
        XMLElementIF rootElem = ta.getXML();
        try {
            String typeName = rootElem.getAttrString("_type");
            int type = TypeMapper.getType(typeName);
            switch (type) {
                case 11: {
                    obj = new Boolean(this.getValue(rootElem));
                    break;
                }
                case 12: {
                    char c = this.getValue(rootElem).charAt(0);
                    obj = new Character(c);
                    break;
                }
                case 13: {
                    obj = new Byte(this.getValue(rootElem));
                    break;
                }
                case 14: {
                    obj = new Short(this.getValue(rootElem));
                    break;
                }
                case 15: {
                    obj = new Integer(this.getValue(rootElem));
                    break;
                }
                case 16: {
                    obj = new Long(this.getValue(rootElem));
                    break;
                }
                case 17: {
                    obj = new Float(this.getValue(rootElem));
                    break;
                }
                case 18: {
                    obj = new Double(this.getValue(rootElem));
                    break;
                }
                case 19: {
                    obj = new String(this.getValue(rootElem));
                    break;
                }
                default: {
                    throw new TypeMappingNotFoundException(typeName);
                }
            }
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
        return obj;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
    }
}

