/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Method;

class MethodSerializer
extends AbstractSerializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/MethodSerializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.lang.reflect.Method");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static SerializerIF instance = null;

    MethodSerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new MethodSerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        Method method = (Method)ta.getCurrent().getObject();
        Class<?> cls = method.getDeclaringClass();
        String name = method.getName();
        Class<?>[] classes = method.getParameterTypes();
        String value = cls.getName() + "@" + name;
        for (int i = 0; i < classes.length; ++i) {
            value = value + "@" + classes[i].getName();
        }
        rootElem.add(this.createValueElem(value));
        return rootElem;
    }
}

