/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SecurityViolationException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.TypeMapper;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;

class MethodDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/MethodDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.lang.reflect.Method");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    MethodDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new MethodDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        Method obj = null;
        XMLElementIF rootElem = ta.getXML();
        try {
            String value = this.getValue(rootElem);
            StringTokenizer tok = new StringTokenizer(value, "@");
            int num = tok.countTokens();
            Class<?> cls = Class.forName(tok.nextToken());
            String name = tok.nextToken();
            Class[] params = new Class[num - 2];
            block8: for (int i = 0; i < num - 2; ++i) {
                String param = tok.nextToken();
                int type = TypeMapper.getType(param);
                switch (type) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: {
                        params[i] = TypeMapper.getPrimitiveClass(type);
                        continue block8;
                    }
                    default: {
                        params[i] = Class.forName(param);
                    }
                }
            }
            obj = cls.getDeclaredMethod(name, params);
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, rootElem);
        }
        catch (ClassNotFoundException cnfE) {
            throw new SerialException(new JavaException(cnfE));
        }
        catch (SecurityException sE) {
            throw new SecurityViolationException(new JavaException(sE));
        }
        catch (NoSuchMethodException nsmE) {
            throw new SerialException(new JavaException(nsmE));
        }
        return obj;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
    }
}

