/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.diag.JavaException;
import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.LinkedList;

class LinkedListDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/LinkedListDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.LinkedList");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    LinkedListDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new LinkedListDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    public void deserialize(Object target, DeserializerTransactionIF ta) throws SerialException {
        LinkedList list = (LinkedList)target;
        SerialToolkit.setValue(list, this.createHeader(list), "header");
        this.process(list, ta);
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        return new LinkedList();
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        LinkedList list = (LinkedList)obj;
        XMLElementIF rootElem = ta.getXML();
        Iterator it = rootElem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF val = (XMLElementIF)it.next();
            Object valObj = null;
            if (!val.getName().equals("_null")) {
                valObj = ta.process(val);
            }
            list.add(valObj);
        }
    }

    protected Object createHeader(LinkedList list) throws SerialException {
        try {
            Class<?> cls = SerialToolkit.getField(list, "header").getType();
            Class[] params = new Class[]{Object.class, cls, cls};
            Constructor<?> ctor = cls.getDeclaredConstructor(params);
            ctor.setAccessible(true);
            Object obj = ctor.newInstance(null, null, null);
            SerialToolkit.setValue(obj, obj, "next");
            SerialToolkit.setValue(obj, obj, "previous");
            return obj;
        }
        catch (Exception e) {
            throw new SerialException(new JavaException(e));
        }
    }
}

