/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

class HashtableSerializer
extends AbstractSerializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/HashtableSerializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.Hashtable");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static SerializerIF instance = null;

    HashtableSerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new HashtableSerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        Hashtable table = (Hashtable)ta.getCurrent().getObject();
        rootElem.setAttr("threshold", this.getThreshold(table));
        rootElem.setAttr("loadFactor", this.getLoadFactor(table));
        rootElem.setAttr("length", this.getLength(table));
        rootElem.setAttr("count", Integer.toString(table.size()));
        Iterator it = table.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            XMLElementIF key = ta.process(e.getKey());
            XMLElementIF val = ta.process(e.getValue());
            key = key == null ? SerialToolkit.NULL_ELEMENT : key;
            val = val == null ? SerialToolkit.NULL_ELEMENT : val;
            rootElem.add(key);
            rootElem.add(val);
        }
        return rootElem;
    }

    protected String getThreshold(Hashtable table) throws SerialException {
        return ((Integer)SerialToolkit.getValue(table, "threshold")).toString();
    }

    protected String getLoadFactor(Hashtable table) throws SerialException {
        return ((Float)SerialToolkit.getValue(table, "loadFactor")).toString();
    }

    protected String getLength(Hashtable table) throws SerialException {
        int length = Array.getLength(SerialToolkit.getValue(table, "table"));
        return Integer.toString(length);
    }
}

