/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.lang.reflect.Array;
import java.util.Hashtable;
import java.util.Iterator;

class HashtableDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/HashtableDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.Hashtable");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    HashtableDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new HashtableDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    public void deserialize(Object target, DeserializerTransactionIF ta) throws SerialException {
        Hashtable table = (Hashtable)target;
        XMLElementIF rootElem = ta.getXML();
        int length = this.getLength(rootElem);
        SerialToolkit.setValue(table, this.getThreshold(rootElem), "threshold");
        SerialToolkit.setValue(table, this.getLoadFactor(rootElem), "loadFactor");
        SerialToolkit.setValue(table, this.createEntries(table, length), "table");
        this.process(table, ta);
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        int initialCapacity = this.getLength(rootElem);
        float loadFactor = this.getLoadFactor(rootElem).floatValue();
        Hashtable table = new Hashtable(initialCapacity, loadFactor);
        SerialToolkit.setValue(table, this.getThreshold(rootElem), "threshold");
        return table;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        Hashtable table = (Hashtable)obj;
        XMLElementIF rootElem = ta.getXML();
        Iterator it = rootElem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF key = (XMLElementIF)it.next();
            XMLElementIF val = (XMLElementIF)it.next();
            Object keyObj = null;
            if (!key.getName().equals("_null")) {
                keyObj = ta.process(key);
            }
            Object valObj = null;
            if (!val.getName().equals("_null")) {
                valObj = ta.process(val);
            }
            table.put(keyObj, valObj);
        }
    }

    protected Integer getThreshold(XMLElementIF elem) throws SerialException {
        try {
            return new Integer(elem.getAttrInteger("threshold"));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected Float getLoadFactor(XMLElementIF elem) throws SerialException {
        try {
            return new Float(elem.getAttrString("loadFactor"));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected int getLength(XMLElementIF elem) throws SerialException {
        try {
            int origLength = elem.getAttrInteger("length");
            int elements = elem.getAttrInteger("count");
            float loadFactor = this.getLoadFactor(elem).floatValue();
            int length = (int)((float)elements * loadFactor) + elements / 20 + 3;
            if (length > elements && (length & 1) == 0) {
                --length;
            }
            if (origLength > 0 && length > origLength) {
                length = origLength;
            }
            return length;
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected Object createEntries(Hashtable table, int length) throws SerialException {
        Class<?> arrCls = SerialToolkit.getField(table, "table").getType();
        return Array.newInstance(arrCls.getComponentType(), length);
    }
}

