/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractSerializer;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.serial.SerializerIF;
import com.sap.sdt.util.serial.SerializerTransactionIF;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class HashMapSerializer
extends AbstractSerializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/HashMapSerializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.HashMap");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static SerializerIF instance = null;

    HashMapSerializer() {
    }

    public static SerializerIF instance() {
        if (instance == null) {
            instance = new HashMapSerializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    protected XMLElementIF process(SerializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = this.createRootElem(ta.getCurrent());
        HashMap map = (HashMap)ta.getCurrent().getObject();
        rootElem.setAttr("threshold", this.getThreshold(map));
        rootElem.setAttr("loadFactor", this.getLoadFactor(map));
        rootElem.setAttr("length", this.getLength(map));
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            XMLElementIF key = ta.process(e.getKey());
            XMLElementIF val = ta.process(e.getValue());
            key = key == null ? SerialToolkit.NULL_ELEMENT : key;
            val = val == null ? SerialToolkit.NULL_ELEMENT : val;
            rootElem.add(key);
            rootElem.add(val);
        }
        return rootElem;
    }

    protected String getThreshold(HashMap map) throws SerialException {
        return ((Integer)SerialToolkit.getValue(map, "threshold")).toString();
    }

    protected String getLoadFactor(HashMap map) throws SerialException {
        return ((Float)SerialToolkit.getValue(map, "loadFactor")).toString();
    }

    protected String getLength(HashMap map) throws SerialException {
        int length = Array.getLength(SerialToolkit.getValue(map, "table"));
        return Integer.toString(length);
    }
}

