/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sdt.util.serial;

import com.sap.sdt.util.serial.AbstractDeserializer;
import com.sap.sdt.util.serial.DeserializerIF;
import com.sap.sdt.util.serial.DeserializerTransactionIF;
import com.sap.sdt.util.serial.MalformedElementException;
import com.sap.sdt.util.serial.SerialException;
import com.sap.sdt.util.serial.SerialID;
import com.sap.sdt.util.serial.SerialToolkit;
import com.sap.sdt.util.vers.VersionFactory;
import com.sap.sdt.util.vers.VersionIF;
import com.sap.sdt.util.xml.XMLElementIF;
import com.sap.sdt.util.xml.XMLException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Iterator;

class HashMapDeserializer
extends AbstractDeserializer {
    public static final String RCSINFO = "$Id: //sdt/com.sap.sdt/0.1/src/_util/java/com/sap/sdt/util/serial/HashMapDeserializer.java#2 $";
    private static final SerialID serialID = new SerialID("java.util.HashMap");
    private static final VersionIF version = VersionFactory.createVersion("1.0");
    private static DeserializerIF instance = null;

    HashMapDeserializer() {
    }

    public static DeserializerIF instance() {
        if (instance == null) {
            instance = new HashMapDeserializer();
        }
        return instance;
    }

    public SerialID getSerialID() {
        return serialID;
    }

    public VersionIF getVersion() {
        return version;
    }

    public void deserialize(Object target, DeserializerTransactionIF ta) throws SerialException {
        HashMap map = (HashMap)target;
        XMLElementIF rootElem = ta.getXML();
        SerialToolkit.setValue(map, this.getThreshold(rootElem), "threshold");
        SerialToolkit.setValue(map, this.getLoadFactor(rootElem), "loadFactor");
        SerialToolkit.setValue(map, this.createEntries(map, this.getLength(rootElem)), "table");
        this.process(map, ta);
    }

    protected Object createObject(DeserializerTransactionIF ta) throws SerialException {
        XMLElementIF rootElem = ta.getXML();
        int initialCapacity = this.getLength(rootElem);
        float loadFactor = this.getLoadFactor(rootElem).floatValue();
        HashMap map = new HashMap(initialCapacity, loadFactor);
        SerialToolkit.setValue(map, this.getThreshold(rootElem), "threshold");
        return map;
    }

    protected void process(Object obj, DeserializerTransactionIF ta) throws SerialException {
        HashMap map = (HashMap)obj;
        XMLElementIF rootElem = ta.getXML();
        Iterator it = rootElem.getSubElements();
        while (it.hasNext()) {
            XMLElementIF key = (XMLElementIF)it.next();
            XMLElementIF val = (XMLElementIF)it.next();
            Object keyObj = null;
            if (!key.getName().equals("_null")) {
                keyObj = ta.process(key);
            }
            Object valObj = null;
            if (!val.getName().equals("_null")) {
                valObj = ta.process(val);
            }
            map.put(keyObj, valObj);
        }
    }

    protected Integer getThreshold(XMLElementIF elem) throws SerialException {
        try {
            return new Integer(elem.getAttrInteger("threshold"));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected Float getLoadFactor(XMLElementIF elem) throws SerialException {
        try {
            return new Float(elem.getAttrString("loadFactor"));
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected int getLength(XMLElementIF elem) throws SerialException {
        try {
            return elem.getAttrInteger("length");
        }
        catch (XMLException xmlE) {
            throw new MalformedElementException(xmlE, elem);
        }
    }

    protected Object createEntries(HashMap map, int length) throws SerialException {
        Class<?> arrCls = SerialToolkit.getField(map, "table").getType();
        return Array.newInstance(arrCls.getComponentType(), length);
    }
}

